/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocol.packet;

import com.google.common.base.X;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.Direction;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.TypeConverter;
import com.viaversion.viaversion.exception.CancelException;
import com.viaversion.viaversion.exception.InformativeException;
import com.viaversion.viaversion.protocol.packet.PacketWrapperImpl$PacketValue;
import com.viaversion.viaversion.util.PipelineUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PacketWrapperImpl
implements PacketWrapper {
    private static final Protocol[] PROTOCOL_ARRAY = new Protocol[0];
    private final Deque<PacketWrapperImpl$PacketValue> readableObjects = new ArrayDeque<PacketWrapperImpl$PacketValue>();
    private final List<PacketWrapperImpl$PacketValue> packetValues = new ArrayList<PacketWrapperImpl$PacketValue>();
    private final ByteBuf inputBuffer;
    private final UserConnection userConnection;
    private boolean send = true;
    private PacketType packetType;
    private int id;

    public PacketWrapperImpl(int n2, @Nullable ByteBuf byteBuf, UserConnection userConnection) {
        this.id = n2;
        this.inputBuffer = byteBuf;
        this.userConnection = userConnection;
    }

    public PacketWrapperImpl(@Nullable PacketType packetType, @Nullable ByteBuf byteBuf, UserConnection userConnection) {
        this.packetType = packetType;
        this.id = packetType != null ? packetType.getId() : -1;
        this.inputBuffer = byteBuf;
        this.userConnection = userConnection;
    }

    @Override
    public <T> T get(Type<T> type, int n2) {
        int n3 = 0;
        for (PacketWrapperImpl$PacketValue packetWrapperImpl$PacketValue : this.packetValues) {
            if (packetWrapperImpl$PacketValue.type() != type) continue;
            if (n3 == n2) {
                return (T)packetWrapperImpl$PacketValue.value();
            }
            ++n3;
        }
        throw this.createInformativeException(new ArrayIndexOutOfBoundsException("Could not find type " + type.getTypeName() + " at " + n2), type, n2);
    }

    @Override
    public boolean is(Type type, int n2) {
        int n3 = 0;
        for (PacketWrapperImpl$PacketValue packetWrapperImpl$PacketValue : this.packetValues) {
            if (packetWrapperImpl$PacketValue.type() != type) continue;
            if (n3 == n2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public boolean isReadable(Type type, int n2) {
        int n3 = 0;
        for (PacketWrapperImpl$PacketValue packetWrapperImpl$PacketValue : this.readableObjects) {
            if (packetWrapperImpl$PacketValue.type().getBaseClass() != type.getBaseClass()) continue;
            if (n3 == n2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public <T> void set(Type<T> type, int n2, T t2) {
        int n3 = 0;
        for (PacketWrapperImpl$PacketValue packetWrapperImpl$PacketValue : this.packetValues) {
            if (packetWrapperImpl$PacketValue.type() != type) continue;
            if (n3 == n2) {
                packetWrapperImpl$PacketValue.setValue(this.attemptTransform(type, t2));
                return;
            }
            ++n3;
        }
        throw this.createInformativeException(new ArrayIndexOutOfBoundsException("Could not find type " + type.getTypeName() + " at " + n2), type, n2);
    }

    @Override
    public <T> T read(Type<T> type) {
        if (type == Type.NOTHING) {
            return null;
        }
        if (this.readableObjects.isEmpty()) {
            X.a(this.inputBuffer, (Object)"This packet does not have an input buffer.");
            try {
                return type.read(this.inputBuffer);
            }
            catch (Exception exception) {
                throw this.createInformativeException(exception, type, this.packetValues.size() + 1);
            }
        }
        PacketWrapperImpl$PacketValue packetWrapperImpl$PacketValue = this.readableObjects.poll();
        Type type2 = packetWrapperImpl$PacketValue.type();
        if (type2 == type || type.getBaseClass() == type2.getBaseClass() && type.getOutputClass() == type2.getOutputClass()) {
            return (T)packetWrapperImpl$PacketValue.value();
        }
        if (type2 == Type.NOTHING) {
            return this.read(type);
        }
        throw this.createInformativeException(new IOException("Unable to read type " + type.getTypeName() + ", found " + packetWrapperImpl$PacketValue.type().getTypeName()), type, this.readableObjects.size());
    }

    @Override
    public <T> void write(Type<T> type, T t2) {
        this.packetValues.add(new PacketWrapperImpl$PacketValue(type, this.attemptTransform(type, t2), null));
    }

    private @Nullable Object attemptTransform(Type<?> type, @Nullable Object object) {
        if (object != null && !type.getOutputClass().isAssignableFrom(object.getClass())) {
            if (type instanceof TypeConverter) {
                return ((TypeConverter)((Object)type)).from(object);
            }
            Via.getPlatform().getLogger().warning("Possible type mismatch: " + object.getClass().getName() + " -> " + type.getOutputClass());
        }
        return object;
    }

    @Override
    public <T> T passthrough(Type<T> type) {
        T t2 = this.read(type);
        this.write(type, t2);
        return t2;
    }

    @Override
    public void writeToBuffer(ByteBuf byteBuf) {
        if (this.id != -1) {
            Type.VAR_INT.writePrimitive(byteBuf, this.id);
        }
        if (!this.readableObjects.isEmpty()) {
            this.packetValues.addAll(this.readableObjects);
            this.readableObjects.clear();
        }
        int n2 = 0;
        for (PacketWrapperImpl$PacketValue packetWrapperImpl$PacketValue : this.packetValues) {
            try {
                packetWrapperImpl$PacketValue.type().write(byteBuf, packetWrapperImpl$PacketValue.value());
            }
            catch (Exception exception) {
                throw this.createInformativeException(exception, packetWrapperImpl$PacketValue.type(), n2);
            }
            ++n2;
        }
        this.writeRemaining(byteBuf);
    }

    private InformativeException createInformativeException(Exception exception, Type<?> type, int n2) {
        return new InformativeException(exception).set("Index", n2).set("Type", type.getTypeName()).set("Packet ID", this.id).set("Packet Type", this.packetType).set("Data", this.packetValues);
    }

    @Override
    public void clearInputBuffer() {
        if (this.inputBuffer != null) {
            this.inputBuffer.clear();
        }
        this.readableObjects.clear();
    }

    @Override
    public void clearPacket() {
        this.clearInputBuffer();
        this.packetValues.clear();
    }

    private void writeRemaining(ByteBuf byteBuf) {
        if (this.inputBuffer != null) {
            byteBuf.writeBytes(this.inputBuffer);
        }
    }

    @Override
    public void send(Class<? extends Protocol> clazz, boolean bl2) {
        this.send0(clazz, bl2, true);
    }

    @Override
    public void scheduleSend(Class<? extends Protocol> clazz, boolean bl2) {
        this.send0(clazz, bl2, false);
    }

    private void send0(Class<? extends Protocol> clazz, boolean bl2, boolean bl3) {
        if (this.isCancelled()) {
            return;
        }
        UserConnection userConnection = this.user();
        if (bl3) {
            block4: {
                try {
                    ByteBuf byteBuf = this.constructPacket(clazz, bl2, Direction.CLIENTBOUND);
                    userConnection.sendRawPacket(byteBuf);
                }
                catch (Exception exception) {
                    if (PipelineUtil.containsCause(exception, CancelException.class)) break block4;
                    throw exception;
                }
            }
            return;
        }
        userConnection.getChannel().eventLoop().submit(() -> {
            block4: {
                try {
                    ByteBuf byteBuf = this.constructPacket(clazz, bl2, Direction.CLIENTBOUND);
                    userConnection.sendRawPacket(byteBuf);
                }
                catch (RuntimeException runtimeException) {
                    if (!PipelineUtil.containsCause(runtimeException, CancelException.class)) {
                        throw runtimeException;
                    }
                }
                catch (Exception exception) {
                    if (PipelineUtil.containsCause(exception, CancelException.class)) break block4;
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf constructPacket(Class<? extends Protocol> clazz, boolean bl2, Direction direction) {
        Protocol[] protocolArray = this.user().getProtocolInfo().getPipeline().pipes().toArray(PROTOCOL_ARRAY);
        boolean bl3 = direction == Direction.CLIENTBOUND;
        int n2 = -1;
        for (int i2 = 0; i2 < protocolArray.length; ++i2) {
            if (protocolArray[i2].getClass() != clazz) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            throw new NoSuchElementException(clazz.getCanonicalName());
        }
        if (bl2) {
            n2 = bl3 ? n2 - 1 : n2 + 1;
        }
        this.resetReader();
        this.apply(direction, this.user().getProtocolInfo().getState(), n2, protocolArray, bl3);
        ByteBuf byteBuf = this.inputBuffer == null ? this.user().getChannel().alloc().buffer() : this.inputBuffer.alloc().buffer();
        try {
            this.writeToBuffer(byteBuf);
            ByteBuf byteBuf2 = byteBuf.retain();
            return byteBuf2;
        }
        finally {
            byteBuf.release();
        }
    }

    @Override
    public ChannelFuture sendFuture(Class<? extends Protocol> clazz) {
        if (!this.isCancelled()) {
            ByteBuf byteBuf = this.constructPacket(clazz, true, Direction.CLIENTBOUND);
            return this.user().sendRawPacketFuture(byteBuf);
        }
        return this.user().getChannel().newFailedFuture(new Exception("Cancelled packet"));
    }

    @Override
    public PacketWrapperImpl create(int n2) {
        return new PacketWrapperImpl(n2, null, this.user());
    }

    @Override
    public PacketWrapperImpl create(int n2, PacketHandler packetHandler) {
        PacketWrapperImpl packetWrapperImpl = this.create(n2);
        packetHandler.handle(packetWrapperImpl);
        return packetWrapperImpl;
    }

    @Override
    public PacketWrapperImpl apply(Direction direction, State state, int n2, List<Protocol> list, boolean bl2) {
        Protocol[] protocolArray = list.toArray(PROTOCOL_ARRAY);
        return this.apply(direction, state, bl2 ? protocolArray.length - 1 : n2, protocolArray, bl2);
    }

    private PacketWrapperImpl apply(Direction direction, State state, int n2, Protocol[] protocolArray, boolean bl2) {
        if (bl2) {
            for (int i2 = n2; i2 >= 0; --i2) {
                protocolArray[i2].transform(direction, state, this);
                this.resetReader();
            }
        } else {
            for (int i3 = n2; i3 < protocolArray.length; ++i3) {
                protocolArray[i3].transform(direction, state, this);
                this.resetReader();
            }
        }
        return this;
    }

    @Override
    public boolean isCancelled() {
        return !this.send;
    }

    @Override
    public void setCancelled(boolean bl2) {
        this.send = !bl2;
    }

    @Override
    public UserConnection user() {
        return this.userConnection;
    }

    @Override
    public void resetReader() {
        for (int i2 = this.packetValues.size() - 1; i2 >= 0; --i2) {
            this.readableObjects.addFirst(this.packetValues.get(i2));
        }
        this.packetValues.clear();
    }

    @Override
    public void sendToServer(Class<? extends Protocol> clazz, boolean bl2) {
        this.sendToServer0(clazz, bl2, true);
    }

    @Override
    public void scheduleSendToServer(Class<? extends Protocol> clazz, boolean bl2) {
        this.sendToServer0(clazz, bl2, false);
    }

    private void sendToServer0(Class<? extends Protocol> clazz, boolean bl2, boolean bl3) {
        if (this.isCancelled()) {
            return;
        }
        UserConnection userConnection = this.user();
        if (bl3) {
            block4: {
                try {
                    ByteBuf byteBuf = this.constructPacket(clazz, bl2, Direction.SERVERBOUND);
                    userConnection.sendRawPacketToServer(byteBuf);
                }
                catch (Exception exception) {
                    if (PipelineUtil.containsCause(exception, CancelException.class)) break block4;
                    throw exception;
                }
            }
            return;
        }
        userConnection.getChannel().eventLoop().submit(() -> {
            block4: {
                try {
                    ByteBuf byteBuf = this.constructPacket(clazz, bl2, Direction.SERVERBOUND);
                    userConnection.sendRawPacketToServer(byteBuf);
                }
                catch (RuntimeException runtimeException) {
                    if (!PipelineUtil.containsCause(runtimeException, CancelException.class)) {
                        throw runtimeException;
                    }
                }
                catch (Exception exception) {
                    if (PipelineUtil.containsCause(exception, CancelException.class)) break block4;
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    @Override
    public @Nullable PacketType getPacketType() {
        return this.packetType;
    }

    @Override
    public void setPacketType(PacketType packetType) {
        this.packetType = packetType;
        this.id = packetType != null ? packetType.getId() : -1;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @Deprecated
    public void setId(int n2) {
        this.packetType = null;
        this.id = n2;
    }

    public String toString() {
        return "PacketWrapper{type=" + this.packetType + ", id=" + this.id + ", values=" + this.packetValues + ", readable=" + this.readableObjects + '}';
    }
}

