/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.opennbt.tag.builtin;

import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.libs.opennbt.tag.limiter.TagLimiter;
import java.io.DataInput;
import java.io.DataOutput;

public class StringTag
extends Tag {
    private String value;

    public StringTag() {
        this("");
    }

    public StringTag(String string) {
        if (string == null) {
            throw new NullPointerException("value cannot be null");
        }
        this.value = string;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        if (string == null) {
            throw new NullPointerException("value cannot be null");
        }
        this.value = string;
    }

    @Override
    public void read(DataInput dataInput, TagLimiter tagLimiter, int n2) {
        this.value = dataInput.readUTF();
        tagLimiter.countBytes(2 * this.value.length());
    }

    @Override
    public void write(DataOutput dataOutput) {
        dataOutput.writeUTF(this.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StringTag stringTag = (StringTag)object;
        return this.value.equals(stringTag.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public final StringTag clone() {
        return new StringTag(this.value);
    }

    @Override
    public int getTagId() {
        return 8;
    }
}

