/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.opennbt.tag.builtin;

import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.libs.opennbt.tag.limiter.TagLimiter;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;

public class LongArrayTag
extends Tag {
    private static final long[] EMPTY_ARRAY = new long[0];
    private long[] value;

    public LongArrayTag() {
        this(EMPTY_ARRAY);
    }

    public LongArrayTag(long[] lArray) {
        if (lArray == null) {
            throw new NullPointerException("value cannot be null");
        }
        this.value = lArray;
    }

    public long[] getValue() {
        return this.value;
    }

    public void setValue(long[] lArray) {
        if (lArray == null) {
            throw new NullPointerException("value cannot be null");
        }
        this.value = lArray;
    }

    public int length() {
        return this.value.length;
    }

    @Override
    public void read(DataInput dataInput, TagLimiter tagLimiter, int n2) {
        tagLimiter.countInt();
        this.value = new long[dataInput.readInt()];
        tagLimiter.countBytes(8 * this.value.length);
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            this.value[i2] = dataInput.readLong();
        }
    }

    @Override
    public void write(DataOutput dataOutput) {
        dataOutput.writeInt(this.value.length);
        for (long l2 : this.value) {
            dataOutput.writeLong(l2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LongArrayTag longArrayTag = (LongArrayTag)object;
        return Arrays.equals(this.value, longArrayTag.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public final LongArrayTag clone() {
        return new LongArrayTag((long[])this.value.clone());
    }

    @Override
    public int getTagId() {
        return 12;
    }
}

