/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.opennbt.tag.builtin;

import com.viaversion.viaversion.libs.opennbt.tag.TagCreateException;
import com.viaversion.viaversion.libs.opennbt.tag.TagRegistry;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.libs.opennbt.tag.limiter.TagLimiter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ListTag
extends Tag
implements Iterable<Tag> {
    private final List<Tag> value;
    private Class<? extends Tag> type;

    public ListTag() {
        this.value = new ArrayList<Tag>();
    }

    public ListTag(@Nullable Class<? extends Tag> clazz) {
        this.type = clazz;
        this.value = new ArrayList<Tag>();
    }

    public ListTag(List<Tag> list) {
        this.value = new ArrayList<Tag>(list.size());
        this.setValue(list);
    }

    @Override
    public List<Tag> getValue() {
        return this.value;
    }

    public void setValue(List<Tag> list) {
        if (list == null) {
            throw new NullPointerException("value cannot be null");
        }
        this.type = null;
        this.value.clear();
        for (Tag tag : list) {
            this.add(tag);
        }
    }

    public boolean add(Tag tag) {
        if (tag == null) {
            throw new NullPointerException("tag cannot be null");
        }
        if (this.type == null) {
            this.type = tag.getClass();
        } else if (tag.getClass() != this.type) {
            throw new IllegalArgumentException("Tag type cannot differ from ListTag type.");
        }
        return this.value.add(tag);
    }

    public boolean remove(Tag tag) {
        return this.value.remove(tag);
    }

    public <T extends Tag> T get(int n2) {
        return (T)this.value.get(n2);
    }

    public int size() {
        return this.value.size();
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.value.iterator();
    }

    @Override
    public void read(DataInput dataInput, TagLimiter tagLimiter, int n2) {
        this.type = null;
        tagLimiter.checkLevel(n2);
        tagLimiter.countBytes(5);
        byte by2 = dataInput.readByte();
        if (by2 != 0) {
            this.type = TagRegistry.getClassFor(by2);
            if (this.type == null) {
                throw new IOException("Unknown tag ID in ListTag: " + by2);
            }
        }
        int n3 = dataInput.readInt();
        int n4 = n2 + 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            Tag tag;
            try {
                tag = TagRegistry.createInstance(by2);
            }
            catch (TagCreateException tagCreateException) {
                throw new IOException("Failed to create tag.", tagCreateException);
            }
            tag.read(dataInput, tagLimiter, n4);
            this.add(tag);
        }
    }

    @Override
    public void write(DataOutput dataOutput) {
        if (this.type == null) {
            dataOutput.writeByte(0);
        } else {
            int n2 = TagRegistry.getIdFor(this.type);
            if (n2 == -1) {
                throw new IOException("ListTag contains unregistered tag class.");
            }
            dataOutput.writeByte(n2);
        }
        dataOutput.writeInt(this.value.size());
        for (Tag tag : this.value) {
            tag.write(dataOutput);
        }
    }

    @Override
    public final ListTag clone() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (Tag tag : this.value) {
            arrayList.add(tag.clone());
        }
        return new ListTag(arrayList);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ListTag listTag = (ListTag)object;
        if (!Objects.equals(this.type, listTag.type)) {
            return false;
        }
        return this.value.equals(listTag.value);
    }

    public int hashCode() {
        int n2 = this.type != null ? this.type.hashCode() : 0;
        n2 = 31 * n2 + this.value.hashCode();
        return n2;
    }

    @Override
    public int getTagId() {
        return 9;
    }
}

