/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.opennbt.tag.builtin;

import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.libs.opennbt.tag.limiter.TagLimiter;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;

public class IntArrayTag
extends Tag {
    private static final int[] EMPTY_ARRAY = new int[0];
    private int[] value;

    public IntArrayTag() {
        this(EMPTY_ARRAY);
    }

    public IntArrayTag(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException("value cannot be null");
        }
        this.value = nArray;
    }

    public int[] getValue() {
        return this.value;
    }

    public int length() {
        return this.value.length;
    }

    @Override
    public void read(DataInput dataInput, TagLimiter tagLimiter, int n2) {
        tagLimiter.countInt();
        this.value = new int[dataInput.readInt()];
        tagLimiter.countBytes(4 * this.value.length);
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            this.value[i2] = dataInput.readInt();
        }
    }

    @Override
    public void write(DataOutput dataOutput) {
        dataOutput.writeInt(this.value.length);
        for (int n2 : this.value) {
            dataOutput.writeInt(n2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IntArrayTag intArrayTag = (IntArrayTag)object;
        return Arrays.equals(this.value, intArrayTag.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public final IntArrayTag clone() {
        return new IntArrayTag((int[])this.value.clone());
    }

    @Override
    public int getTagId() {
        return 11;
    }
}

