/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.opennbt.tag.builtin;

import com.viaversion.viaversion.libs.opennbt.tag.TagCreateException;
import com.viaversion.viaversion.libs.opennbt.tag.TagRegistry;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.libs.opennbt.tag.limiter.TagLimiter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class CompoundTag
extends Tag
implements Iterable<Map.Entry<String, Tag>> {
    private Map<String, Tag> value;

    public CompoundTag() {
        this(new LinkedHashMap<String, Tag>());
    }

    public CompoundTag(Map<String, Tag> map) {
        this.value = new LinkedHashMap<String, Tag>(map);
    }

    public CompoundTag(LinkedHashMap<String, Tag> linkedHashMap) {
        if (linkedHashMap == null) {
            throw new NullPointerException("value cannot be null");
        }
        this.value = linkedHashMap;
    }

    @Override
    public Map<String, Tag> getValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean contains(String string) {
        return this.value.containsKey(string);
    }

    @Nullable
    public <T extends Tag> T get(String string) {
        return (T)this.value.get(string);
    }

    @Nullable
    public <T extends Tag> T put(String string, T t2) {
        return (T)this.value.put(string, t2);
    }

    @Nullable
    public <T extends Tag> T remove(String string) {
        return (T)this.value.remove(string);
    }

    public Collection<Tag> values() {
        return this.value.values();
    }

    public Set<Map.Entry<String, Tag>> entrySet() {
        return this.value.entrySet();
    }

    public int size() {
        return this.value.size();
    }

    @Override
    public Iterator<Map.Entry<String, Tag>> iterator() {
        return this.value.entrySet().iterator();
    }

    @Override
    public void read(DataInput dataInput, TagLimiter tagLimiter, int n2) {
        try {
            tagLimiter.checkLevel(n2);
            int n3 = n2 + 1;
            while (true) {
                tagLimiter.countByte();
                byte by2 = dataInput.readByte();
                if (by2 != 0) {
                    String string = dataInput.readUTF();
                    tagLimiter.countBytes(2 * string.length());
                    Tag tag = TagRegistry.createInstance(by2);
                    tag.read(dataInput, tagLimiter, n3);
                    this.value.put(string, tag);
                    continue;
                }
                break;
            }
        }
        catch (TagCreateException tagCreateException) {
            throw new IOException("Failed to create tag.", tagCreateException);
        }
        catch (EOFException eOFException) {
            throw new IOException("Closing tag was not found!");
        }
    }

    @Override
    public void write(DataOutput dataOutput) {
        for (Map.Entry<String, Tag> entry : this.value.entrySet()) {
            Tag tag = entry.getValue();
            dataOutput.writeByte(tag.getTagId());
            dataOutput.writeUTF(entry.getKey());
            tag.write(dataOutput);
        }
        dataOutput.writeByte(0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CompoundTag compoundTag = (CompoundTag)object;
        return this.value.equals(compoundTag.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public final CompoundTag clone() {
        LinkedHashMap<String, Tag> linkedHashMap = new LinkedHashMap<String, Tag>();
        for (Map.Entry<String, Tag> entry : this.value.entrySet()) {
            linkedHashMap.put(entry.getKey(), entry.getValue().clone());
        }
        return new CompoundTag(linkedHashMap);
    }

    @Override
    public int getTagId() {
        return 10;
    }
}

