/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.opennbt.tag.builtin;

import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.libs.opennbt.tag.limiter.TagLimiter;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;

public class ByteArrayTag
extends Tag {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private byte[] value;

    public ByteArrayTag() {
        this(EMPTY_ARRAY);
    }

    public ByteArrayTag(byte[] byArray) {
        this.value = byArray;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void read(DataInput dataInput, TagLimiter tagLimiter, int n2) {
        tagLimiter.countInt();
        this.value = new byte[dataInput.readInt()];
        tagLimiter.countBytes(this.value.length);
        dataInput.readFully(this.value);
    }

    @Override
    public void write(DataOutput dataOutput) {
        dataOutput.writeInt(this.value.length);
        dataOutput.write(this.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ByteArrayTag byteArrayTag = (ByteArrayTag)object;
        return Arrays.equals(this.value, byteArrayTag.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public final ByteArrayTag clone() {
        return new ByteArrayTag(this.value);
    }

    @Override
    public int getTagId() {
        return 7;
    }
}

