/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.opennbt;

import com.viaversion.viaversion.libs.opennbt.NBTIO$LittleEndianDataInputStream;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.limiter.TagLimiter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;

public final class NBTIO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompoundTag readFile(File file, boolean bl2, boolean bl3) {
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            CompoundTag compoundTag;
            if (bl2) {
                inputStream = new GZIPInputStream(inputStream);
            }
            if (!((compoundTag = NBTIO.readTag(inputStream, bl3)) instanceof CompoundTag)) {
                throw new IOException("Root tag is not a CompoundTag!");
            }
            CompoundTag compoundTag2 = compoundTag;
            return compoundTag2;
        }
    }

    public static CompoundTag readTag(InputStream inputStream) {
        return NBTIO.readTag(inputStream, TagLimiter.noop());
    }

    public static CompoundTag readTag(InputStream inputStream, TagLimiter tagLimiter) {
        return NBTIO.readTag(new DataInputStream(inputStream), tagLimiter);
    }

    public static CompoundTag readTag(InputStream inputStream, boolean bl2) {
        return NBTIO.readTag((DataInput)((Object)(bl2 ? new NBTIO$LittleEndianDataInputStream(inputStream, null) : new DataInputStream(inputStream))));
    }

    public static CompoundTag readTag(DataInput dataInput) {
        return NBTIO.readTag(dataInput, TagLimiter.noop());
    }

    public static CompoundTag readTag(DataInput dataInput, TagLimiter tagLimiter) {
        byte by2 = dataInput.readByte();
        if (by2 != 10) {
            throw new IOException(String.format("Expected root tag to be a CompoundTag, was %s", by2));
        }
        dataInput.skipBytes(dataInput.readUnsignedShort());
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.read(dataInput, tagLimiter);
        return compoundTag;
    }

    public static void writeTag(DataOutput dataOutput, CompoundTag compoundTag) {
        dataOutput.writeByte(10);
        dataOutput.writeUTF("");
        compoundTag.write(dataOutput);
    }
}

