/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Index<K, V> {
    private final Map<K, V> keyToValue;
    private final Map<V, K> valueToKey;

    private Index(Map<K, V> map, Map<V, K> map2) {
        this.keyToValue = map;
        this.valueToKey = map2;
    }

    @NotNull
    public static <K, V extends Enum<V>> Index<K, V> create(Class<V> clazz, @NotNull Function<? super V, ? extends K> function) {
        return Index.create(clazz, function, (Enum[])((Enum[])clazz.getEnumConstants()));
    }

    @SafeVarargs
    @NotNull
    public static <K, V extends Enum<V>> Index<K, V> create(Class<V> clazz, @NotNull Function<? super V, ? extends K> function, V ... VArray) {
        return Index.create(VArray, (int n2) -> new EnumMap(clazz), function);
    }

    @SafeVarargs
    @NotNull
    public static <K, V> Index<K, V> create(@NotNull Function<? super V, ? extends K> function, V ... VArray) {
        return Index.create(VArray, HashMap::new, function);
    }

    @NotNull
    public static <K, V> Index<K, V> create(@NotNull Function<? super V, ? extends K> function, @NotNull List<V> list) {
        return Index.create(list, HashMap::new, function);
    }

    @NotNull
    private static <K, V> Index<K, V> create(V[] VArray, IntFunction<Map<V, K>> intFunction, @NotNull Function<? super V, ? extends K> function) {
        return Index.create(Arrays.asList(VArray), intFunction, function);
    }

    @NotNull
    private static <K, V> Index<K, V> create(List<V> list, IntFunction<Map<V, K>> intFunction, @NotNull Function<? super V, ? extends K> function) {
        int n2 = list.size();
        HashMap<K, V> hashMap = new HashMap<K, V>(n2);
        Map<K, V> map = intFunction.apply(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            V v2 = list.get(i2);
            K k2 = function.apply(v2);
            if (hashMap.putIfAbsent(k2, v2) != null) {
                throw new IllegalStateException(String.format("Key %s already mapped to value %s", k2, hashMap.get(k2)));
            }
            if (map.putIfAbsent(v2, k2) == null) continue;
            throw new IllegalStateException(String.format("Value %s already mapped to key %s", v2, map.get(v2)));
        }
        return new Index(Collections.unmodifiableMap(hashMap), Collections.unmodifiableMap(map));
    }

    @NotNull
    public Set<K> keys() {
        return Collections.unmodifiableSet(this.keyToValue.keySet());
    }

    @Nullable
    public K key(@NotNull V v2) {
        return this.valueToKey.get(v2);
    }

    @Nullable
    public V value(@NotNull K k2) {
        return this.keyToValue.get(k2);
    }
}

