/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.util;

import com.viaversion.viaversion.libs.kyori.adventure.internal.Internals;
import com.viaversion.viaversion.libs.kyori.adventure.util.HSVLike;
import com.viaversion.viaversion.libs.kyori.adventure.util.ShadyPines;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

final class HSVLikeImpl
implements HSVLike {
    private final float h;
    private final float s;
    private final float v;

    HSVLikeImpl(float f2, float f3, float f4) {
        HSVLikeImpl.requireInsideRange(f2, "h");
        HSVLikeImpl.requireInsideRange(f3, "s");
        HSVLikeImpl.requireInsideRange(f4, "v");
        this.h = f2;
        this.s = f3;
        this.v = f4;
    }

    @Override
    public float h() {
        return this.h;
    }

    @Override
    public float s() {
        return this.s;
    }

    @Override
    public float v() {
        return this.v;
    }

    private static void requireInsideRange(float f2, String string) {
        if (f2 < 0.0f || 1.0f < f2) {
            throw new IllegalArgumentException(string + " (" + f2 + ") is not inside the required range: [0,1]");
        }
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HSVLikeImpl)) {
            return false;
        }
        HSVLikeImpl hSVLikeImpl = (HSVLikeImpl)object;
        return ShadyPines.equals(hSVLikeImpl.h, this.h) && ShadyPines.equals(hSVLikeImpl.s, this.s) && ShadyPines.equals(hSVLikeImpl.v, this.v);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.h), Float.valueOf(this.s), Float.valueOf(this.v));
    }

    public String toString() {
        return Internals.toString(this);
    }
}

