/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.util;

import com.viaversion.viaversion.libs.kyori.adventure.util.HSVLikeImpl;
import com.viaversion.viaversion.libs.kyori.examination.Examinable;
import com.viaversion.viaversion.libs.kyori.examination.ExaminableProperty;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface HSVLike
extends Examinable {
    @NotNull
    public static HSVLike fromRGB(@Range(from=0L, to=255L) int n2, @Range(from=0L, to=255L) int n3, @Range(from=0L, to=255L) int n4) {
        float f2 = (float)n2 / 255.0f;
        float f3 = (float)n3 / 255.0f;
        float f4 = (float)n4 / 255.0f;
        float f5 = Math.min(f2, Math.min(f3, f4));
        float f6 = Math.max(f2, Math.max(f3, f4));
        float f7 = f6 - f5;
        float f8 = f6 != 0.0f ? f7 / f6 : 0.0f;
        if (f8 == 0.0f) {
            return new HSVLikeImpl(0.0f, f8, f6);
        }
        float f9 = f2 == f6 ? (f3 - f4) / f7 : (f3 == f6 ? 2.0f + (f4 - f2) / f7 : 4.0f + (f2 - f3) / f7);
        if ((f9 *= 60.0f) < 0.0f) {
            f9 += 360.0f;
        }
        return new HSVLikeImpl(f9 / 360.0f, f8, f6);
    }

    public float h();

    public float s();

    public float v();

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("h", this.h()), ExaminableProperty.of("s", this.s()), ExaminableProperty.of("v", this.v()));
    }
}

