/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.text.serializer.legacy;

import com.viaversion.viaversion.libs.kyori.adventure.text.Component;
import com.viaversion.viaversion.libs.kyori.adventure.text.TextComponent;
import com.viaversion.viaversion.libs.kyori.adventure.text.TextComponent$Builder;
import com.viaversion.viaversion.libs.kyori.adventure.text.TextReplacementConfig;
import com.viaversion.viaversion.libs.kyori.adventure.text.flattener.ComponentFlattener;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.NamedTextColor;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextColor;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextDecoration;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextDecoration$State;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextFormat;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer$Builder;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer$Provider;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializerImpl$Cereal;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializerImpl$DecodedFormat;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializerImpl$FormatCodeType;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializerImpl$Reset;
import com.viaversion.viaversion.libs.kyori.adventure.util.Services;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LegacyComponentSerializerImpl
implements LegacyComponentSerializer {
    static final Pattern DEFAULT_URL_PATTERN = Pattern.compile("(?:(https?)://)?([-\\w_.]+\\.\\w{2,})(/\\S*)?");
    static final Pattern URL_SCHEME_PATTERN = Pattern.compile("^[a-z][a-z0-9+\\-.]*:");
    private static final TextDecoration[] DECORATIONS = TextDecoration.values();
    private static final List<TextFormat> FORMATS;
    private static final String LEGACY_CHARS;
    private static final Optional<LegacyComponentSerializer$Provider> SERVICE;
    static final Consumer<LegacyComponentSerializer$Builder> BUILDER;
    private final char character;
    private final char hexCharacter;
    @Nullable
    private final TextReplacementConfig urlReplacementConfig;
    private final boolean hexColours;
    private final boolean useTerriblyStupidHexFormat;
    private final ComponentFlattener flattener;

    LegacyComponentSerializerImpl(char c2, char c3, @Nullable TextReplacementConfig textReplacementConfig, boolean bl2, boolean bl3, ComponentFlattener componentFlattener) {
        this.character = c2;
        this.hexCharacter = c3;
        this.urlReplacementConfig = textReplacementConfig;
        this.hexColours = bl2;
        this.useTerriblyStupidHexFormat = bl3;
        this.flattener = componentFlattener;
    }

    @Nullable
    private LegacyComponentSerializerImpl$FormatCodeType determineFormatType(char c2, String string, int n2) {
        if (n2 >= 14) {
            int n3 = n2 - 14;
            int n4 = n2 - 13;
            if (string.charAt(n3) == this.character && string.charAt(n4) == 'x') {
                return LegacyComponentSerializerImpl$FormatCodeType.BUNGEECORD_UNUSUAL_HEX;
            }
        }
        if (c2 == this.hexCharacter && string.length() - n2 >= 6) {
            return LegacyComponentSerializerImpl$FormatCodeType.KYORI_HEX;
        }
        if (LEGACY_CHARS.indexOf(c2) != -1) {
            return LegacyComponentSerializerImpl$FormatCodeType.MOJANG_LEGACY;
        }
        return null;
    }

    @Nullable
    private LegacyComponentSerializerImpl$DecodedFormat decodeTextFormat(char c2, String string, int n2) {
        LegacyComponentSerializerImpl$FormatCodeType legacyComponentSerializerImpl$FormatCodeType = this.determineFormatType(c2, string, n2);
        if (legacyComponentSerializerImpl$FormatCodeType == null) {
            return null;
        }
        if (legacyComponentSerializerImpl$FormatCodeType == LegacyComponentSerializerImpl$FormatCodeType.KYORI_HEX) {
            @Nullable TextColor textColor = LegacyComponentSerializerImpl.tryParseHexColor(string.substring(n2, n2 + 6));
            if (textColor != null) {
                return new LegacyComponentSerializerImpl$DecodedFormat(legacyComponentSerializerImpl$FormatCodeType, textColor, null);
            }
        } else {
            if (legacyComponentSerializerImpl$FormatCodeType == LegacyComponentSerializerImpl$FormatCodeType.MOJANG_LEGACY) {
                return new LegacyComponentSerializerImpl$DecodedFormat(legacyComponentSerializerImpl$FormatCodeType, FORMATS.get(LEGACY_CHARS.indexOf(c2)), null);
            }
            if (legacyComponentSerializerImpl$FormatCodeType == LegacyComponentSerializerImpl$FormatCodeType.BUNGEECORD_UNUSUAL_HEX) {
                StringBuilder stringBuilder = new StringBuilder(6);
                for (int i2 = n2 - 1; i2 >= n2 - 11; i2 -= 2) {
                    stringBuilder.append(string.charAt(i2));
                }
                @Nullable TextColor textColor = LegacyComponentSerializerImpl.tryParseHexColor(stringBuilder.reverse().toString());
                if (textColor != null) {
                    return new LegacyComponentSerializerImpl$DecodedFormat(legacyComponentSerializerImpl$FormatCodeType, textColor, null);
                }
            }
        }
        return null;
    }

    @Nullable
    private static TextColor tryParseHexColor(String string) {
        try {
            int n2 = Integer.parseInt(string, 16);
            return TextColor.color(n2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static boolean isHexTextColor(TextFormat textFormat) {
        return textFormat instanceof TextColor && !(textFormat instanceof NamedTextColor);
    }

    private String toLegacyCode(TextFormat textFormat) {
        if (LegacyComponentSerializerImpl.isHexTextColor(textFormat)) {
            TextColor textColor = (TextColor)textFormat;
            if (this.hexColours) {
                String string = String.format("%06x", textColor.value());
                if (this.useTerriblyStupidHexFormat) {
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf('x'));
                    int n2 = string.length();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        stringBuilder.append(this.character).append(string.charAt(i2));
                    }
                    return stringBuilder.toString();
                }
                return this.hexCharacter + string;
            }
            textFormat = NamedTextColor.nearestTo(textColor);
        }
        int n3 = FORMATS.indexOf(textFormat);
        return Character.toString(LEGACY_CHARS.charAt(n3));
    }

    private TextComponent extractUrl(TextComponent textComponent) {
        if (this.urlReplacementConfig == null) {
            return textComponent;
        }
        Component component = textComponent.replaceText(this.urlReplacementConfig);
        if (component instanceof TextComponent) {
            return (TextComponent)component;
        }
        return (TextComponent)((TextComponent$Builder)Component.text().append(component)).build();
    }

    @Override
    @NotNull
    public TextComponent deserialize(@NotNull String string) {
        Object object;
        int n2 = string.lastIndexOf(this.character, string.length() - 2);
        if (n2 == -1) {
            return this.extractUrl(Component.text(string));
        }
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        TextComponent$Builder textComponent$Builder = null;
        boolean bl2 = false;
        int n3 = string.length();
        do {
            if ((object = this.decodeTextFormat(string.charAt(n2 + 1), string, n2 + 2)) == null) continue;
            int n4 = n2 + (((LegacyComponentSerializerImpl$DecodedFormat)object).encodedFormat == LegacyComponentSerializerImpl$FormatCodeType.KYORI_HEX ? 8 : 2);
            if (n4 != n3) {
                if (textComponent$Builder != null) {
                    if (bl2) {
                        arrayList.add((TextComponent)textComponent$Builder.build());
                        bl2 = false;
                        textComponent$Builder = Component.text();
                    } else {
                        textComponent$Builder = (TextComponent$Builder)Component.text().append((Component)textComponent$Builder.build());
                    }
                } else {
                    textComponent$Builder = Component.text();
                }
                textComponent$Builder.content(string.substring(n4, n3));
            } else if (textComponent$Builder == null) {
                textComponent$Builder = Component.text();
            }
            if (!bl2) {
                bl2 = LegacyComponentSerializerImpl.applyFormat(textComponent$Builder, ((LegacyComponentSerializerImpl$DecodedFormat)object).format);
            }
            if (((LegacyComponentSerializerImpl$DecodedFormat)object).encodedFormat == LegacyComponentSerializerImpl$FormatCodeType.BUNGEECORD_UNUSUAL_HEX) {
                n2 -= 12;
            }
            n3 = n2;
        } while ((n2 = string.lastIndexOf(this.character, n2 - 1)) != -1);
        if (textComponent$Builder != null) {
            arrayList.add((TextComponent)textComponent$Builder.build());
        }
        Object object2 = object = n3 > 0 ? string.substring(0, n3) : "";
        if (arrayList.size() == 1 && ((String)object).isEmpty()) {
            return this.extractUrl((TextComponent)arrayList.get(0));
        }
        Collections.reverse(arrayList);
        return this.extractUrl((TextComponent)((TextComponent$Builder)Component.text().content((String)object).append(arrayList)).build());
    }

    @Override
    @NotNull
    public String serialize(@NotNull Component component) {
        LegacyComponentSerializerImpl$Cereal legacyComponentSerializerImpl$Cereal = new LegacyComponentSerializerImpl$Cereal(this, null);
        this.flattener.flatten(component, legacyComponentSerializerImpl$Cereal);
        return legacyComponentSerializerImpl$Cereal.toString();
    }

    private static boolean applyFormat(@NotNull TextComponent$Builder textComponent$Builder, @NotNull TextFormat textFormat) {
        if (textFormat instanceof TextColor) {
            textComponent$Builder.colorIfAbsent((TextColor)textFormat);
            return true;
        }
        if (textFormat instanceof TextDecoration) {
            textComponent$Builder.decoration((TextDecoration)textFormat, TextDecoration$State.TRUE);
            return false;
        }
        if (textFormat instanceof LegacyComponentSerializerImpl$Reset) {
            return true;
        }
        throw new IllegalArgumentException(String.format("unknown format '%s'", textFormat.getClass()));
    }

    static /* synthetic */ Optional access$000() {
        return SERVICE;
    }

    static /* synthetic */ String access$300(LegacyComponentSerializerImpl legacyComponentSerializerImpl, TextFormat textFormat) {
        return legacyComponentSerializerImpl.toLegacyCode(textFormat);
    }

    static /* synthetic */ char access$400(LegacyComponentSerializerImpl legacyComponentSerializerImpl) {
        return legacyComponentSerializerImpl.character;
    }

    static /* synthetic */ TextDecoration[] access$500() {
        return DECORATIONS;
    }

    static {
        LinkedHashMap<TextFormat, String> linkedHashMap = new LinkedHashMap<TextFormat, String>(22);
        linkedHashMap.put(NamedTextColor.BLACK, "0");
        linkedHashMap.put(NamedTextColor.DARK_BLUE, "1");
        linkedHashMap.put(NamedTextColor.DARK_GREEN, "2");
        linkedHashMap.put(NamedTextColor.DARK_AQUA, "3");
        linkedHashMap.put(NamedTextColor.DARK_RED, "4");
        linkedHashMap.put(NamedTextColor.DARK_PURPLE, "5");
        linkedHashMap.put(NamedTextColor.GOLD, "6");
        linkedHashMap.put(NamedTextColor.GRAY, "7");
        linkedHashMap.put(NamedTextColor.DARK_GRAY, "8");
        linkedHashMap.put(NamedTextColor.BLUE, "9");
        linkedHashMap.put(NamedTextColor.GREEN, "a");
        linkedHashMap.put(NamedTextColor.AQUA, "b");
        linkedHashMap.put(NamedTextColor.RED, "c");
        linkedHashMap.put(NamedTextColor.LIGHT_PURPLE, "d");
        linkedHashMap.put(NamedTextColor.YELLOW, "e");
        linkedHashMap.put(NamedTextColor.WHITE, "f");
        linkedHashMap.put(TextDecoration.OBFUSCATED, "k");
        linkedHashMap.put(TextDecoration.BOLD, "l");
        linkedHashMap.put(TextDecoration.STRIKETHROUGH, "m");
        linkedHashMap.put(TextDecoration.UNDERLINED, "n");
        linkedHashMap.put(TextDecoration.ITALIC, "o");
        linkedHashMap.put(LegacyComponentSerializerImpl$Reset.INSTANCE, "r");
        FORMATS = Collections.unmodifiableList(new ArrayList(linkedHashMap.keySet()));
        LEGACY_CHARS = String.join((CharSequence)"", linkedHashMap.values());
        if (FORMATS.size() != LEGACY_CHARS.length()) {
            throw new IllegalStateException("FORMATS length differs from LEGACY_CHARS length");
        }
        SERVICE = Services.service(LegacyComponentSerializer$Provider.class);
        BUILDER = SERVICE.map(LegacyComponentSerializer$Provider::legacy).orElseGet(() -> legacyComponentSerializer$Builder -> {});
    }
}

