/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.text.serializer.gson.legacyimpl;

import com.viaversion.viaversion.libs.kyori.adventure.key.Key;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.CompoundBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.CompoundBinaryTag$Builder;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.TagStringIO;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.api.BinaryTagHolder;
import com.viaversion.viaversion.libs.kyori.adventure.text.Component;
import com.viaversion.viaversion.libs.kyori.adventure.text.TextComponent;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEvent$ShowEntity;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEvent$ShowItem;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import com.viaversion.viaversion.libs.kyori.adventure.util.Codec;
import com.viaversion.viaversion.libs.kyori.adventure.util.Codec$Decoder;
import com.viaversion.viaversion.libs.kyori.adventure.util.Codec$Encoder;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NBTLegacyHoverEventSerializerImpl
implements LegacyHoverEventSerializer {
    static final NBTLegacyHoverEventSerializerImpl INSTANCE = new NBTLegacyHoverEventSerializerImpl();
    private static final TagStringIO SNBT_IO = TagStringIO.get();
    private static final Codec<CompoundBinaryTag, String, IOException, IOException> SNBT_CODEC = Codec.codec(SNBT_IO::asCompound, SNBT_IO::asString);

    private NBTLegacyHoverEventSerializerImpl() {
    }

    @Override
    public @NotNull HoverEvent$ShowItem deserializeShowItem(@NotNull Component component) {
        NBTLegacyHoverEventSerializerImpl.assertTextComponent(component);
        CompoundBinaryTag compoundBinaryTag = SNBT_CODEC.decode(((TextComponent)component).content());
        CompoundBinaryTag compoundBinaryTag2 = compoundBinaryTag.getCompound("tag");
        return HoverEvent$ShowItem.of(Key.key(compoundBinaryTag.getString("id")), compoundBinaryTag.getByte("Count", (byte)1), compoundBinaryTag2 == CompoundBinaryTag.empty() ? null : BinaryTagHolder.encode(compoundBinaryTag2, SNBT_CODEC));
    }

    @Override
    public @NotNull HoverEvent$ShowEntity deserializeShowEntity(@NotNull Component component, Codec$Decoder<Component, String, ? extends RuntimeException> codec$Decoder) {
        NBTLegacyHoverEventSerializerImpl.assertTextComponent(component);
        CompoundBinaryTag compoundBinaryTag = SNBT_CODEC.decode(((TextComponent)component).content());
        return HoverEvent$ShowEntity.of(Key.key(compoundBinaryTag.getString("type")), UUID.fromString(compoundBinaryTag.getString("id")), codec$Decoder.decode(compoundBinaryTag.getString("name")));
    }

    private static void assertTextComponent(Component component) {
        if (!(component instanceof TextComponent) || !component.children().isEmpty()) {
            throw new IllegalArgumentException("Legacy events must be single Component instances");
        }
    }

    @Override
    @NotNull
    public Component serializeShowItem(@NotNull HoverEvent$ShowItem hoverEvent$ShowItem) {
        CompoundBinaryTag$Builder compoundBinaryTag$Builder = (CompoundBinaryTag$Builder)((CompoundBinaryTag$Builder)CompoundBinaryTag.builder().putString("id", hoverEvent$ShowItem.item().asString())).putByte("Count", (byte)hoverEvent$ShowItem.count());
        @Nullable BinaryTagHolder binaryTagHolder = hoverEvent$ShowItem.nbt();
        if (binaryTagHolder != null) {
            compoundBinaryTag$Builder.put("tag", binaryTagHolder.get(SNBT_CODEC));
        }
        return Component.text(SNBT_CODEC.encode(compoundBinaryTag$Builder.build()));
    }

    @Override
    @NotNull
    public Component serializeShowEntity(@NotNull HoverEvent$ShowEntity hoverEvent$ShowEntity, Codec$Encoder<Component, String, ? extends RuntimeException> codec$Encoder) {
        CompoundBinaryTag$Builder compoundBinaryTag$Builder = (CompoundBinaryTag$Builder)((CompoundBinaryTag$Builder)CompoundBinaryTag.builder().putString("id", hoverEvent$ShowEntity.id().toString())).putString("type", hoverEvent$ShowEntity.type().asString());
        @Nullable Component component = hoverEvent$ShowEntity.name();
        if (component != null) {
            compoundBinaryTag$Builder.putString("name", codec$Encoder.encode(component));
        }
        return Component.text(SNBT_CODEC.encode(compoundBinaryTag$Builder.build()));
    }
}

