/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.text.serializer.gson;

import com.viaversion.viaversion.libs.gson.Gson;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.gson.JsonParseException;
import com.viaversion.viaversion.libs.gson.JsonSyntaxException;
import com.viaversion.viaversion.libs.gson.TypeAdapter;
import com.viaversion.viaversion.libs.gson.stream.JsonReader;
import com.viaversion.viaversion.libs.gson.stream.JsonToken;
import com.viaversion.viaversion.libs.gson.stream.JsonWriter;
import com.viaversion.viaversion.libs.kyori.adventure.key.Key;
import com.viaversion.viaversion.libs.kyori.adventure.text.Component;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.ClickEvent;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.ClickEvent$Action;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEvent;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEvent$Action;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEvent$ShowEntity;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEvent$ShowItem;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style$Builder;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextColor;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextDecoration;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextDecoration$State;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.gson.SerializerFactory;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.gson.TextColorWrapper;
import com.viaversion.viaversion.libs.kyori.adventure.util.Codec$Decoder;
import com.viaversion.viaversion.libs.kyori.adventure.util.Codec$Encoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.EnumSet;
import org.jetbrains.annotations.Nullable;

final class StyleSerializer
extends TypeAdapter<Style> {
    private static final TextDecoration[] DECORATIONS = new TextDecoration[]{TextDecoration.BOLD, TextDecoration.ITALIC, TextDecoration.UNDERLINED, TextDecoration.STRIKETHROUGH, TextDecoration.OBFUSCATED};
    private final LegacyHoverEventSerializer legacyHover;
    private final boolean emitLegacyHover;
    private final Gson gson;

    static TypeAdapter<Style> create(@Nullable LegacyHoverEventSerializer legacyHoverEventSerializer, boolean bl2, Gson gson) {
        return new StyleSerializer(legacyHoverEventSerializer, bl2, gson).nullSafe();
    }

    private StyleSerializer(@Nullable LegacyHoverEventSerializer legacyHoverEventSerializer, boolean bl2, Gson gson) {
        this.legacyHover = legacyHoverEventSerializer;
        this.emitLegacyHover = bl2;
        this.gson = gson;
    }

    @Override
    public Style read(JsonReader jsonReader) {
        jsonReader.beginObject();
        Style$Builder style$Builder = Style.style();
        while (jsonReader.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            String string = jsonReader.nextName();
            if (string.equals("font")) {
                style$Builder.font((Key)this.gson.fromJson(jsonReader, SerializerFactory.KEY_TYPE));
                continue;
            }
            if (string.equals("color")) {
                object3 = (TextColorWrapper)this.gson.fromJson(jsonReader, SerializerFactory.COLOR_WRAPPER_TYPE);
                if (((TextColorWrapper)object3).color != null) {
                    style$Builder.color(((TextColorWrapper)object3).color);
                    continue;
                }
                if (((TextColorWrapper)object3).decoration == null) continue;
                style$Builder.decoration(((TextColorWrapper)object3).decoration, TextDecoration$State.TRUE);
                continue;
            }
            if (TextDecoration.NAMES.keys().contains(string)) {
                style$Builder.decoration(TextDecoration.NAMES.value(string), this.readBoolean(jsonReader));
                continue;
            }
            if (string.equals("insertion")) {
                style$Builder.insertion(jsonReader.nextString());
                continue;
            }
            if (string.equals("clickEvent")) {
                jsonReader.beginObject();
                object3 = null;
                object2 = null;
                while (jsonReader.hasNext()) {
                    object = jsonReader.nextName();
                    if (((String)object).equals("action")) {
                        object3 = (ClickEvent$Action)((Object)this.gson.fromJson(jsonReader, SerializerFactory.CLICK_ACTION_TYPE));
                        continue;
                    }
                    if (((String)object).equals("value")) {
                        object2 = jsonReader.peek() == JsonToken.NULL ? null : jsonReader.nextString();
                        continue;
                    }
                    jsonReader.skipValue();
                }
                if (object3 != null && ((ClickEvent$Action)((Object)object3)).readable() && object2 != null) {
                    style$Builder.clickEvent(ClickEvent.clickEvent((ClickEvent$Action)((Object)object3), (String)object2));
                }
                jsonReader.endObject();
                continue;
            }
            if (string.equals("hoverEvent")) {
                Object object4;
                Object object5;
                JsonElement jsonElement;
                object3 = (JsonObject)this.gson.fromJson(jsonReader, (Type)((Object)JsonObject.class));
                if (object3 == null || (object2 = ((JsonObject)object3).getAsJsonPrimitive("action")) == null || !((HoverEvent$Action)(object = this.gson.fromJson((JsonElement)object2, SerializerFactory.HOVER_ACTION_TYPE))).readable()) continue;
                if (((JsonObject)object3).has("contents")) {
                    jsonElement = ((JsonObject)object3).get("contents");
                    object5 = ((HoverEvent$Action)object).type();
                    object4 = StyleSerializer.isNullOrEmpty(jsonElement) ? null : (SerializerFactory.COMPONENT_TYPE.isAssignableFrom((Class<?>)object5) ? this.gson.fromJson(jsonElement, SerializerFactory.COMPONENT_TYPE) : (SerializerFactory.SHOW_ITEM_TYPE.isAssignableFrom((Class<?>)object5) ? this.gson.fromJson(jsonElement, SerializerFactory.SHOW_ITEM_TYPE) : (SerializerFactory.SHOW_ENTITY_TYPE.isAssignableFrom((Class<?>)object5) ? this.gson.fromJson(jsonElement, SerializerFactory.SHOW_ENTITY_TYPE) : null)));
                } else if (((JsonObject)object3).has("value")) {
                    jsonElement = ((JsonObject)object3).get("value");
                    if (StyleSerializer.isNullOrEmpty(jsonElement)) {
                        object4 = null;
                    } else {
                        object5 = this.gson.fromJson(jsonElement, SerializerFactory.COMPONENT_TYPE);
                        object4 = this.legacyHoverEventContents((HoverEvent$Action<?>)object, (Component)object5);
                    }
                } else {
                    object4 = null;
                }
                if (object4 == null) continue;
                style$Builder.hoverEvent(HoverEvent.hoverEvent(object, object4));
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return style$Builder.build();
    }

    private static boolean isNullOrEmpty(@Nullable JsonElement jsonElement) {
        return jsonElement == null || jsonElement.isJsonNull() || jsonElement.isJsonArray() && jsonElement.getAsJsonArray().size() == 0 || jsonElement.isJsonObject() && jsonElement.getAsJsonObject().size() == 0;
    }

    private boolean readBoolean(JsonReader jsonReader) {
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.BOOLEAN) {
            return jsonReader.nextBoolean();
        }
        if (jsonToken == JsonToken.STRING || jsonToken == JsonToken.NUMBER) {
            return Boolean.parseBoolean(jsonReader.nextString());
        }
        throw new JsonParseException("Token of type " + (Object)((Object)jsonToken) + " cannot be interpreted as a boolean");
    }

    private Object legacyHoverEventContents(HoverEvent$Action<?> hoverEvent$Action, Component component) {
        if (hoverEvent$Action == HoverEvent$Action.SHOW_TEXT) {
            return component;
        }
        if (this.legacyHover != null) {
            try {
                if (hoverEvent$Action == HoverEvent$Action.SHOW_ENTITY) {
                    return this.legacyHover.deserializeShowEntity(component, this.decoder());
                }
                if (hoverEvent$Action == HoverEvent$Action.SHOW_ITEM) {
                    return this.legacyHover.deserializeShowItem(component);
                }
            }
            catch (IOException iOException) {
                throw new JsonParseException(iOException);
            }
        }
        throw new UnsupportedOperationException();
    }

    private Codec$Decoder<Component, String, JsonParseException> decoder() {
        return string -> this.gson.fromJson((String)string, SerializerFactory.COMPONENT_TYPE);
    }

    private Codec$Encoder<Component, String, JsonParseException> encoder() {
        return component -> this.gson.toJson(component, SerializerFactory.COMPONENT_TYPE);
    }

    @Override
    public void write(JsonWriter jsonWriter, Style style) {
        ClickEvent clickEvent;
        String string;
        HoverEvent$Action hoverEvent$Action;
        Object object;
        jsonWriter.beginObject();
        for (TextDecoration object22 : DECORATIONS) {
            object = style.decoration(object22);
            if (object == TextDecoration$State.NOT_SET) continue;
            hoverEvent$Action = TextDecoration.NAMES.key(object22);
            assert (hoverEvent$Action != null);
            jsonWriter.name((String)((Object)hoverEvent$Action));
            jsonWriter.value(object == TextDecoration$State.TRUE);
        }
        @Nullable TextColor textColor = style.color();
        if (textColor != null) {
            jsonWriter.name("color");
            this.gson.toJson((Object)textColor, SerializerFactory.COLOR_TYPE, jsonWriter);
        }
        if ((string = style.insertion()) != null) {
            jsonWriter.name("insertion");
            jsonWriter.value(string);
        }
        if ((clickEvent = style.clickEvent()) != null) {
            jsonWriter.name("clickEvent");
            jsonWriter.beginObject();
            jsonWriter.name("action");
            this.gson.toJson((Object)clickEvent.action(), SerializerFactory.CLICK_ACTION_TYPE, jsonWriter);
            jsonWriter.name("value");
            jsonWriter.value(clickEvent.value());
            jsonWriter.endObject();
        }
        if ((object = style.hoverEvent()) != null) {
            jsonWriter.name("hoverEvent");
            jsonWriter.beginObject();
            jsonWriter.name("action");
            hoverEvent$Action = ((HoverEvent)object).action();
            this.gson.toJson(hoverEvent$Action, SerializerFactory.HOVER_ACTION_TYPE, jsonWriter);
            jsonWriter.name("contents");
            if (hoverEvent$Action == HoverEvent$Action.SHOW_ITEM) {
                this.gson.toJson(((HoverEvent)object).value(), SerializerFactory.SHOW_ITEM_TYPE, jsonWriter);
            } else if (hoverEvent$Action == HoverEvent$Action.SHOW_ENTITY) {
                this.gson.toJson(((HoverEvent)object).value(), SerializerFactory.SHOW_ENTITY_TYPE, jsonWriter);
            } else if (hoverEvent$Action == HoverEvent$Action.SHOW_TEXT) {
                this.gson.toJson(((HoverEvent)object).value(), SerializerFactory.COMPONENT_TYPE, jsonWriter);
            } else {
                throw new JsonParseException("Don't know how to serialize " + ((HoverEvent)object).value());
            }
            if (this.emitLegacyHover) {
                jsonWriter.name("value");
                this.serializeLegacyHoverEvent((HoverEvent<?>)object, jsonWriter);
            }
            jsonWriter.endObject();
        }
        if ((hoverEvent$Action = style.font()) != null) {
            jsonWriter.name("font");
            this.gson.toJson(hoverEvent$Action, SerializerFactory.KEY_TYPE, jsonWriter);
        }
        jsonWriter.endObject();
    }

    private void serializeLegacyHoverEvent(HoverEvent<?> hoverEvent, JsonWriter jsonWriter) {
        if (hoverEvent.action() == HoverEvent$Action.SHOW_TEXT) {
            this.gson.toJson(hoverEvent.value(), SerializerFactory.COMPONENT_TYPE, jsonWriter);
        } else if (this.legacyHover != null) {
            Component component = null;
            try {
                if (hoverEvent.action() == HoverEvent$Action.SHOW_ENTITY) {
                    component = this.legacyHover.serializeShowEntity((HoverEvent$ShowEntity)hoverEvent.value(), this.encoder());
                } else if (hoverEvent.action() == HoverEvent$Action.SHOW_ITEM) {
                    component = this.legacyHover.serializeShowItem((HoverEvent$ShowItem)hoverEvent.value());
                }
            }
            catch (IOException iOException) {
                throw new JsonSyntaxException(iOException);
            }
            if (component != null) {
                this.gson.toJson((Object)component, SerializerFactory.COMPONENT_TYPE, jsonWriter);
            } else {
                jsonWriter.nullValue();
            }
        } else {
            jsonWriter.nullValue();
        }
    }

    static {
        EnumSet<TextDecoration> enumSet = EnumSet.allOf(TextDecoration.class);
        for (TextDecoration textDecoration : DECORATIONS) {
            enumSet.remove(textDecoration);
        }
        if (!enumSet.isEmpty()) {
            throw new IllegalStateException("Gson serializer is missing some text decorations: " + enumSet);
        }
    }
}

