/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.text.serializer.gson;

import com.viaversion.viaversion.libs.gson.Gson;
import com.viaversion.viaversion.libs.gson.JsonParseException;
import com.viaversion.viaversion.libs.gson.TypeAdapter;
import com.viaversion.viaversion.libs.gson.stream.JsonReader;
import com.viaversion.viaversion.libs.gson.stream.JsonToken;
import com.viaversion.viaversion.libs.gson.stream.JsonWriter;
import com.viaversion.viaversion.libs.kyori.adventure.key.Key;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.api.BinaryTagHolder;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEvent$ShowItem;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.gson.SerializerFactory;

final class ShowItemSerializer
extends TypeAdapter<HoverEvent$ShowItem> {
    private final Gson gson;

    static TypeAdapter<HoverEvent$ShowItem> create(Gson gson) {
        return new ShowItemSerializer(gson).nullSafe();
    }

    private ShowItemSerializer(Gson gson) {
        this.gson = gson;
    }

    @Override
    public HoverEvent$ShowItem read(JsonReader jsonReader) {
        jsonReader.beginObject();
        Key key = null;
        int n2 = 1;
        BinaryTagHolder binaryTagHolder = null;
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            if (string.equals("id")) {
                key = (Key)this.gson.fromJson(jsonReader, SerializerFactory.KEY_TYPE);
                continue;
            }
            if (string.equals("count")) {
                n2 = jsonReader.nextInt();
                continue;
            }
            if (string.equals("tag")) {
                JsonToken jsonToken = jsonReader.peek();
                if (jsonToken == JsonToken.STRING || jsonToken == JsonToken.NUMBER) {
                    binaryTagHolder = BinaryTagHolder.binaryTagHolder(jsonReader.nextString());
                    continue;
                }
                if (jsonToken == JsonToken.BOOLEAN) {
                    binaryTagHolder = BinaryTagHolder.binaryTagHolder(String.valueOf(jsonReader.nextBoolean()));
                    continue;
                }
                if (jsonToken == JsonToken.NULL) {
                    jsonReader.nextNull();
                    continue;
                }
                throw new JsonParseException("Expected tag to be a string");
            }
            jsonReader.skipValue();
        }
        if (key == null) {
            throw new JsonParseException("Not sure how to deserialize show_item hover event");
        }
        jsonReader.endObject();
        return HoverEvent$ShowItem.of(key, n2, binaryTagHolder);
    }

    @Override
    public void write(JsonWriter jsonWriter, HoverEvent$ShowItem hoverEvent$ShowItem) {
        BinaryTagHolder binaryTagHolder;
        jsonWriter.beginObject();
        jsonWriter.name("id");
        this.gson.toJson((Object)hoverEvent$ShowItem.item(), SerializerFactory.KEY_TYPE, jsonWriter);
        int n2 = hoverEvent$ShowItem.count();
        if (n2 != 1) {
            jsonWriter.name("count");
            jsonWriter.value(n2);
        }
        if ((binaryTagHolder = hoverEvent$ShowItem.nbt()) != null) {
            jsonWriter.name("tag");
            jsonWriter.value(binaryTagHolder.string());
        }
        jsonWriter.endObject();
    }
}

