/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.text.format;

import com.viaversion.viaversion.libs.kyori.adventure.text.format.NamedTextColor;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextColorImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextFormat;
import com.viaversion.viaversion.libs.kyori.adventure.util.RGBLike;
import com.viaversion.viaversion.libs.kyori.examination.Examinable;
import com.viaversion.viaversion.libs.kyori.examination.ExaminableProperty;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface TextColor
extends TextFormat,
RGBLike,
Examinable,
Comparable<TextColor> {
    @NotNull
    public static TextColor color(int n2) {
        int n3 = n2 & 0xFFFFFF;
        NamedTextColor namedTextColor = NamedTextColor.namedColor(n3);
        return namedTextColor != null ? namedTextColor : new TextColorImpl(n3);
    }

    @Nullable
    public static TextColor fromHexString(@NotNull String string) {
        if (string.startsWith("#")) {
            try {
                int n2 = Integer.parseInt(string.substring(1), 16);
                return TextColor.color(n2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public int value();

    @NotNull
    default public String asHexString() {
        return String.format("#%06x", this.value());
    }

    @Override
    default public @Range(from=0L, to=255L) int red() {
        return this.value() >> 16 & 0xFF;
    }

    @Override
    default public @Range(from=0L, to=255L) int green() {
        return this.value() >> 8 & 0xFF;
    }

    @Override
    default public @Range(from=0L, to=255L) int blue() {
        return this.value() & 0xFF;
    }

    @Override
    default public int compareTo(TextColor textColor) {
        return Integer.compare(this.value(), textColor.value());
    }

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("value", this.asHexString()));
    }
}

