/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.text.format;

import com.viaversion.viaversion.libs.kyori.adventure.internal.Internals;
import com.viaversion.viaversion.libs.kyori.adventure.key.Key;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.ClickEvent;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEvent;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEventSource;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.DecorationMap;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style$Builder;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style$Merge;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style$Merge$Strategy;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.StyleImpl$BuilderImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextColor;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextDecoration;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextDecoration$State;
import com.viaversion.viaversion.libs.kyori.examination.ExaminableProperty;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StyleImpl
implements Style {
    static final StyleImpl EMPTY = new StyleImpl(null, null, DecorationMap.EMPTY, null, null, null);
    @Nullable
    final Key font;
    @Nullable
    final TextColor color;
    @NotNull
    final DecorationMap decorations;
    @Nullable
    final ClickEvent clickEvent;
    @Nullable
    final HoverEvent<?> hoverEvent;
    @Nullable
    final String insertion;

    StyleImpl(@Nullable Key key, @Nullable TextColor textColor, @NotNull Map<TextDecoration, TextDecoration$State> map, @Nullable ClickEvent clickEvent, @Nullable HoverEvent<?> hoverEvent, @Nullable String string) {
        this.font = key;
        this.color = textColor;
        this.decorations = DecorationMap.fromMap(map);
        this.clickEvent = clickEvent;
        this.hoverEvent = hoverEvent;
        this.insertion = string;
    }

    @Override
    @Nullable
    public Key font() {
        return this.font;
    }

    @Override
    @Nullable
    public TextColor color() {
        return this.color;
    }

    @Override
    public @NotNull TextDecoration$State decoration(@NotNull TextDecoration textDecoration) {
        @Nullable TextDecoration$State textDecoration$State = this.decorations.get(textDecoration);
        if (textDecoration$State != null) {
            return textDecoration$State;
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", textDecoration));
    }

    @Override
    @NotNull
    public Style decoration(@NotNull TextDecoration textDecoration, @NotNull TextDecoration$State textDecoration$State) {
        Objects.requireNonNull(textDecoration$State, "state");
        if (this.decoration(textDecoration) == textDecoration$State) {
            return this;
        }
        return new StyleImpl(this.font, this.color, this.decorations.with(textDecoration, textDecoration$State), this.clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    @Nullable
    public ClickEvent clickEvent() {
        return this.clickEvent;
    }

    @Override
    @Nullable
    public HoverEvent<?> hoverEvent() {
        return this.hoverEvent;
    }

    @Override
    @NotNull
    public Style hoverEvent(@Nullable HoverEventSource<?> hoverEventSource) {
        return new StyleImpl(this.font, this.color, this.decorations, this.clickEvent, HoverEventSource.unbox(hoverEventSource), this.insertion);
    }

    @Override
    @Nullable
    public String insertion() {
        return this.insertion;
    }

    @Override
    @NotNull
    public Style merge(@NotNull Style style, @NotNull Style$Merge$Strategy style$Merge$Strategy, @NotNull Set<Style$Merge> set) {
        if (StyleImpl.nothingToMerge(style, style$Merge$Strategy, set)) {
            return this;
        }
        if (this.isEmpty() && Style$Merge.hasAll(set)) {
            return style;
        }
        Style$Builder style$Builder = this.toBuilder();
        style$Builder.merge(style, style$Merge$Strategy, set);
        return style$Builder.build();
    }

    static boolean nothingToMerge(@NotNull Style style, @NotNull Style$Merge$Strategy style$Merge$Strategy, @NotNull Set<Style$Merge> set) {
        if (style$Merge$Strategy == Style$Merge$Strategy.NEVER) {
            return true;
        }
        if (style.isEmpty()) {
            return true;
        }
        return set.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    @NotNull
    public Style$Builder toBuilder() {
        return new StyleImpl$BuilderImpl(this);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.concat(this.decorations.examinableProperties(), Stream.of(ExaminableProperty.of("color", this.color), ExaminableProperty.of("clickEvent", this.clickEvent), ExaminableProperty.of("hoverEvent", this.hoverEvent), ExaminableProperty.of("insertion", this.insertion), ExaminableProperty.of("font", this.font)));
    }

    @NotNull
    public String toString() {
        return Internals.toString(this);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StyleImpl)) {
            return false;
        }
        StyleImpl styleImpl = (StyleImpl)object;
        return Objects.equals(this.color, styleImpl.color) && this.decorations.equals(styleImpl.decorations) && Objects.equals(this.clickEvent, styleImpl.clickEvent) && Objects.equals(this.hoverEvent, styleImpl.hoverEvent) && Objects.equals(this.insertion, styleImpl.insertion) && Objects.equals(this.font, styleImpl.font);
    }

    public int hashCode() {
        int n2 = Objects.hashCode(this.color);
        n2 = 31 * n2 + this.decorations.hashCode();
        n2 = 31 * n2 + Objects.hashCode(this.clickEvent);
        n2 = 31 * n2 + Objects.hashCode(this.hoverEvent);
        n2 = 31 * n2 + Objects.hashCode(this.insertion);
        n2 = 31 * n2 + Objects.hashCode(this.font);
        return n2;
    }
}

