/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.text.format;

import com.viaversion.viaversion.libs.kyori.adventure.key.Key;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.ClickEvent;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEvent;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEventSource;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.DecorationMap;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style$Builder;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style$Merge;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style$Merge$Strategy;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.StyleImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextColor;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextDecoration;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextDecoration$State;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StyleImpl$BuilderImpl
implements Style$Builder {
    @Nullable
    Key font;
    @Nullable
    TextColor color;
    final Map<TextDecoration, TextDecoration$State> decorations;
    @Nullable
    ClickEvent clickEvent;
    @Nullable
    HoverEvent<?> hoverEvent;
    @Nullable
    String insertion;

    StyleImpl$BuilderImpl() {
        this.decorations = new EnumMap<TextDecoration, TextDecoration$State>(DecorationMap.EMPTY);
    }

    StyleImpl$BuilderImpl(@NotNull StyleImpl styleImpl) {
        this.color = styleImpl.color;
        this.decorations = new EnumMap<TextDecoration, TextDecoration$State>(styleImpl.decorations);
        this.clickEvent = styleImpl.clickEvent;
        this.hoverEvent = styleImpl.hoverEvent;
        this.insertion = styleImpl.insertion;
        this.font = styleImpl.font;
    }

    @Override
    @NotNull
    public Style$Builder font(@Nullable Key key) {
        this.font = key;
        return this;
    }

    @Override
    @NotNull
    public Style$Builder color(@Nullable TextColor textColor) {
        this.color = textColor;
        return this;
    }

    @Override
    @NotNull
    public Style$Builder colorIfAbsent(@Nullable TextColor textColor) {
        if (this.color == null) {
            this.color = textColor;
        }
        return this;
    }

    @Override
    @NotNull
    public Style$Builder decoration(@NotNull TextDecoration textDecoration, @NotNull TextDecoration$State textDecoration$State) {
        Objects.requireNonNull(textDecoration$State, "state");
        Objects.requireNonNull(textDecoration, "decoration");
        this.decorations.put(textDecoration, textDecoration$State);
        return this;
    }

    @NotNull
    public Style$Builder decorationIfAbsent(@NotNull TextDecoration textDecoration, @NotNull TextDecoration$State textDecoration$State) {
        Objects.requireNonNull(textDecoration$State, "state");
        @Nullable TextDecoration$State textDecoration$State2 = this.decorations.get(textDecoration);
        if (textDecoration$State2 == TextDecoration$State.NOT_SET) {
            this.decorations.put(textDecoration, textDecoration$State);
        }
        if (textDecoration$State2 != null) {
            return this;
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", textDecoration));
    }

    @Override
    @NotNull
    public Style$Builder clickEvent(@Nullable ClickEvent clickEvent) {
        this.clickEvent = clickEvent;
        return this;
    }

    @Override
    @NotNull
    public Style$Builder hoverEvent(@Nullable HoverEventSource<?> hoverEventSource) {
        this.hoverEvent = HoverEventSource.unbox(hoverEventSource);
        return this;
    }

    @Override
    @NotNull
    public Style$Builder insertion(@Nullable String string) {
        this.insertion = string;
        return this;
    }

    @Override
    @NotNull
    public Style$Builder merge(@NotNull Style style, @NotNull Style$Merge$Strategy style$Merge$Strategy, @NotNull Set<Style$Merge> set) {
        Object object;
        Objects.requireNonNull(style, "style");
        Objects.requireNonNull(style$Merge$Strategy, "strategy");
        Objects.requireNonNull(set, "merges");
        if (StyleImpl.nothingToMerge(style, style$Merge$Strategy, set)) {
            return this;
        }
        if (set.contains((Object)Style$Merge.COLOR) && (object = style.color()) != null && (style$Merge$Strategy == Style$Merge$Strategy.ALWAYS || style$Merge$Strategy == Style$Merge$Strategy.IF_ABSENT_ON_TARGET && this.color == null)) {
            this.color((TextColor)object);
        }
        if (set.contains((Object)Style$Merge.DECORATIONS)) {
            for (TextDecoration textDecoration : DecorationMap.DECORATIONS) {
                TextDecoration$State textDecoration$State = style.decoration(textDecoration);
                if (textDecoration$State == TextDecoration$State.NOT_SET) continue;
                if (style$Merge$Strategy == Style$Merge$Strategy.ALWAYS) {
                    this.decoration(textDecoration, textDecoration$State);
                    continue;
                }
                if (style$Merge$Strategy != Style$Merge$Strategy.IF_ABSENT_ON_TARGET) continue;
                this.decorationIfAbsent(textDecoration, textDecoration$State);
            }
        }
        if (set.contains((Object)Style$Merge.EVENTS)) {
            HoverEvent<?> hoverEvent;
            object = style.clickEvent();
            if (object != null && (style$Merge$Strategy == Style$Merge$Strategy.ALWAYS || style$Merge$Strategy == Style$Merge$Strategy.IF_ABSENT_ON_TARGET && this.clickEvent == null)) {
                this.clickEvent((ClickEvent)object);
            }
            if ((hoverEvent = style.hoverEvent()) != null && (style$Merge$Strategy == Style$Merge$Strategy.ALWAYS || style$Merge$Strategy == Style$Merge$Strategy.IF_ABSENT_ON_TARGET && this.hoverEvent == null)) {
                this.hoverEvent(hoverEvent);
            }
        }
        if (set.contains((Object)Style$Merge.INSERTION) && (object = style.insertion()) != null && (style$Merge$Strategy == Style$Merge$Strategy.ALWAYS || style$Merge$Strategy == Style$Merge$Strategy.IF_ABSENT_ON_TARGET && this.insertion == null)) {
            this.insertion((String)object);
        }
        if (set.contains((Object)Style$Merge.FONT) && (object = style.font()) != null && (style$Merge$Strategy == Style$Merge$Strategy.ALWAYS || style$Merge$Strategy == Style$Merge$Strategy.IF_ABSENT_ON_TARGET && this.font == null)) {
            this.font((Key)object);
        }
        return this;
    }

    @Override
    @NotNull
    public StyleImpl build() {
        if (this.isEmpty()) {
            return StyleImpl.EMPTY;
        }
        return new StyleImpl(this.font, this.color, this.decorations, this.clickEvent, this.hoverEvent, this.insertion);
    }

    private boolean isEmpty() {
        return this.color == null && this.decorations.values().stream().allMatch(textDecoration$State -> textDecoration$State == TextDecoration$State.NOT_SET) && this.clickEvent == null && this.hoverEvent == null && this.insertion == null && this.font == null;
    }
}

