/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.text.format;

import com.viaversion.viaversion.libs.kyori.adventure.text.format.DecorationMap$EntrySet;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.DecorationMap$KeySet;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.DecorationMap$Values;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextDecoration;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextDecoration$State;
import com.viaversion.viaversion.libs.kyori.examination.Examinable;
import com.viaversion.viaversion.libs.kyori.examination.ExaminableProperty;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@Unmodifiable
final class DecorationMap
extends AbstractMap<TextDecoration, TextDecoration$State>
implements Examinable {
    static final TextDecoration[] DECORATIONS = TextDecoration.values();
    private static final TextDecoration$State[] STATES = TextDecoration$State.values();
    private static final int MAP_SIZE = DECORATIONS.length;
    private static final TextDecoration$State[] EMPTY_STATE_ARRAY = new TextDecoration$State[0];
    static final DecorationMap EMPTY = new DecorationMap(0);
    private static final DecorationMap$KeySet KEY_SET = new DecorationMap$KeySet();
    private final int bitSet;
    private volatile DecorationMap$EntrySet entrySet = null;
    private volatile DecorationMap$Values values = null;

    static DecorationMap fromMap(Map<TextDecoration, TextDecoration$State> map) {
        if (map instanceof DecorationMap) {
            return (DecorationMap)map;
        }
        int n2 = 0;
        for (TextDecoration textDecoration : DECORATIONS) {
            n2 |= map.getOrDefault(textDecoration, TextDecoration$State.NOT_SET).ordinal() * DecorationMap.offset(textDecoration);
        }
        return DecorationMap.withBitSet(n2);
    }

    private static DecorationMap withBitSet(int n2) {
        return n2 == 0 ? EMPTY : new DecorationMap(n2);
    }

    private static int offset(TextDecoration textDecoration) {
        return 1 << textDecoration.ordinal() * 2;
    }

    private DecorationMap(int n2) {
        this.bitSet = n2;
    }

    @NotNull
    public DecorationMap with(@NotNull TextDecoration textDecoration, @NotNull TextDecoration$State textDecoration$State) {
        Objects.requireNonNull(textDecoration$State, "state");
        Objects.requireNonNull(textDecoration, "decoration");
        int n2 = DecorationMap.offset(textDecoration);
        return DecorationMap.withBitSet(this.bitSet & ~(3 * n2) | textDecoration$State.ordinal() * n2);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Arrays.stream(DECORATIONS).map(textDecoration -> ExaminableProperty.of(textDecoration.toString(), (Object)this.get(textDecoration)));
    }

    @Override
    public TextDecoration$State get(Object object) {
        if (object instanceof TextDecoration) {
            return STATES[this.bitSet >> ((TextDecoration)object).ordinal() * 2 & 3];
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return object instanceof TextDecoration;
    }

    @Override
    public int size() {
        return MAP_SIZE;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<Map.Entry<TextDecoration, TextDecoration$State>> entrySet() {
        if (this.entrySet == null) {
            DecorationMap decorationMap = this;
            synchronized (decorationMap) {
                if (this.entrySet == null) {
                    this.entrySet = new DecorationMap$EntrySet(this);
                }
            }
        }
        return this.entrySet;
    }

    @Override
    @NotNull
    public Set<TextDecoration> keySet() {
        return KEY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<TextDecoration$State> values() {
        if (this.values == null) {
            DecorationMap decorationMap = this;
            synchronized (decorationMap) {
                if (this.values == null) {
                    this.values = new DecorationMap$Values(this);
                }
            }
        }
        return this.values;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != DecorationMap.class) {
            return false;
        }
        return this.bitSet == ((DecorationMap)object).bitSet;
    }

    @Override
    public int hashCode() {
        return this.bitSet;
    }

    static /* synthetic */ DecorationMap$KeySet access$000() {
        return KEY_SET;
    }

    static /* synthetic */ int access$100() {
        return MAP_SIZE;
    }

    static /* synthetic */ TextDecoration$State[] access$200() {
        return EMPTY_STATE_ARRAY;
    }
}

