/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.text.flattener;

import com.viaversion.viaversion.libs.kyori.adventure.text.Component;
import com.viaversion.viaversion.libs.kyori.adventure.text.KeybindComponent;
import com.viaversion.viaversion.libs.kyori.adventure.text.ScoreComponent;
import com.viaversion.viaversion.libs.kyori.adventure.text.SelectorComponent;
import com.viaversion.viaversion.libs.kyori.adventure.text.TextComponent;
import com.viaversion.viaversion.libs.kyori.adventure.text.TranslatableComponent;
import com.viaversion.viaversion.libs.kyori.adventure.text.flattener.ComponentFlattener;
import com.viaversion.viaversion.libs.kyori.adventure.text.flattener.ComponentFlattenerImpl$BuilderImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.flattener.ComponentFlattenerImpl$Handler;
import com.viaversion.viaversion.libs.kyori.adventure.text.flattener.FlattenerListener;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ComponentFlattenerImpl
implements ComponentFlattener {
    static final ComponentFlattener BASIC = (ComponentFlattener)new ComponentFlattenerImpl$BuilderImpl().mapper(KeybindComponent.class, keybindComponent -> keybindComponent.keybind()).mapper(ScoreComponent.class, ScoreComponent::value).mapper(SelectorComponent.class, SelectorComponent::pattern).mapper(TextComponent.class, TextComponent::content).mapper(TranslatableComponent.class, translatableComponent -> {
        @Nullable String string = translatableComponent.fallback();
        return string != null ? string : translatableComponent.key();
    }).build();
    static final ComponentFlattener TEXT_ONLY = (ComponentFlattener)new ComponentFlattenerImpl$BuilderImpl().mapper(TextComponent.class, TextComponent::content).build();
    private final Map<Class<?>, Function<?, String>> flatteners;
    private final Map<Class<?>, BiConsumer<?, Consumer<Component>>> complexFlatteners;
    private final ConcurrentMap<Class<?>, ComponentFlattenerImpl$Handler> propagatedFlatteners = new ConcurrentHashMap();
    private final Function<Component, String> unknownHandler;

    ComponentFlattenerImpl(Map<Class<?>, Function<?, String>> map, Map<Class<?>, BiConsumer<?, Consumer<Component>>> map2, @Nullable Function<Component, String> function) {
        this.flatteners = Collections.unmodifiableMap(new HashMap(map));
        this.complexFlatteners = Collections.unmodifiableMap(new HashMap(map2));
        this.unknownHandler = function;
    }

    @Override
    public void flatten(@NotNull Component component, @NotNull FlattenerListener flattenerListener) {
        this.flatten0(component, flattenerListener, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flatten0(@NotNull Component component, @NotNull FlattenerListener flattenerListener, int n2) {
        Objects.requireNonNull(component, "input");
        Objects.requireNonNull(flattenerListener, "listener");
        if (component == Component.empty()) {
            return;
        }
        if (n2 > 512) {
            throw new IllegalStateException("Exceeded maximum depth of 512 while attempting to flatten components!");
        }
        @Nullable ComponentFlattenerImpl$Handler componentFlattenerImpl$Handler = this.flattener(component);
        Style style = component.style();
        flattenerListener.pushStyle(style);
        try {
            if (componentFlattenerImpl$Handler != null) {
                componentFlattenerImpl$Handler.handle(component, flattenerListener, n2 + 1);
            }
            if (!component.children().isEmpty()) {
                for (Component component2 : component.children()) {
                    this.flatten0(component2, flattenerListener, n2 + 1);
                }
            }
        }
        finally {
            flattenerListener.popStyle(style);
        }
    }

    @Nullable
    private <T extends Component> ComponentFlattenerImpl$Handler flattener(T t2) {
        ComponentFlattenerImpl$Handler componentFlattenerImpl$Handler = this.propagatedFlatteners.computeIfAbsent(t2.getClass(), clazz -> {
            @Nullable Function<?, String> function = this.flatteners.get(clazz);
            if (function != null) {
                return (component, flattenerListener, n2) -> flattenerListener.component((String)function.apply(component));
            }
            for (Map.Entry<Class<?>, Function<?, String>> entry : this.flatteners.entrySet()) {
                if (!entry.getKey().isAssignableFrom((Class<?>)clazz)) continue;
                return (component, flattenerListener, n2) -> flattenerListener.component((String)((Function)entry.getValue()).apply(component));
            }
            BiConsumer<?, Consumer<Component>> biConsumer = this.complexFlatteners.get(clazz);
            if (biConsumer != null) {
                return (component2, flattenerListener, n2) -> biConsumer.accept(component2, component -> this.flatten0((Component)component, flattenerListener, n2));
            }
            for (Map.Entry entry : this.complexFlatteners.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom((Class<?>)clazz)) continue;
                return (component2, flattenerListener, n2) -> ((BiConsumer)entry.getValue()).accept(component2, component -> this.flatten0((Component)component, flattenerListener, n2));
            }
            return ComponentFlattenerImpl$Handler.NONE;
        });
        if (componentFlattenerImpl$Handler == ComponentFlattenerImpl$Handler.NONE) {
            return this.unknownHandler == null ? null : (component, flattenerListener, n2) -> flattenerListener.component(this.unknownHandler.apply(component));
        }
        return componentFlattenerImpl$Handler;
    }
}

