/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.text;

import com.viaversion.viaversion.libs.kyori.adventure.text.BlockNBTComponent$Builder;
import com.viaversion.viaversion.libs.kyori.adventure.text.BlockNBTComponentImpl$BuilderImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.ComponentLike;
import com.viaversion.viaversion.libs.kyori.adventure.text.EntityNBTComponentImpl$BuilderImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.KeybindComponentImpl$BuilderImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.ScoreComponentImpl$BuilderImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.SelectorComponentImpl$BuilderImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.StorageNBTComponentImpl$BuilderImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.TextComponent;
import com.viaversion.viaversion.libs.kyori.adventure.text.TextComponentImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.TextComponentImpl$BuilderImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.TextReplacementConfig;
import com.viaversion.viaversion.libs.kyori.adventure.text.TextReplacementConfigImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.TextReplacementRenderer;
import com.viaversion.viaversion.libs.kyori.adventure.text.TranslatableComponentImpl$BuilderImpl;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEvent;
import com.viaversion.viaversion.libs.kyori.adventure.text.event.HoverEventSource;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.Style$Builder;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.StyleSetter;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextDecoration;
import com.viaversion.viaversion.libs.kyori.adventure.text.format.TextDecoration$State;
import com.viaversion.viaversion.libs.kyori.examination.Examinable;
import com.viaversion.viaversion.libs.kyori.examination.ExaminableProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public interface Component
extends ComponentLike,
HoverEventSource<Component>,
StyleSetter<Component>,
Examinable {
    public static final BiPredicate<? super Component, ? super Component> EQUALS = Objects::equals;
    public static final BiPredicate<? super Component, ? super Component> EQUALS_IDENTITY = (component, component2) -> component == component2;
    public static final Predicate<? super Component> IS_NOT_EMPTY = component -> component != Component.empty();

    @NotNull
    public static TextComponent empty() {
        return TextComponentImpl.EMPTY;
    }

    @Contract(pure=true)
    public static @NotNull BlockNBTComponent$Builder blockNBT() {
        return new BlockNBTComponentImpl$BuilderImpl();
    }

    @Contract(pure=true)
    public static @NotNull com.viaversion.viaversion.libs.kyori.adventure.text.EntityNBTComponent$Builder entityNBT() {
        return new EntityNBTComponentImpl$BuilderImpl();
    }

    @Contract(pure=true)
    public static @NotNull com.viaversion.viaversion.libs.kyori.adventure.text.KeybindComponent$Builder keybind() {
        return new KeybindComponentImpl$BuilderImpl();
    }

    @Contract(pure=true)
    public static @NotNull com.viaversion.viaversion.libs.kyori.adventure.text.ScoreComponent$Builder score() {
        return new ScoreComponentImpl$BuilderImpl();
    }

    @Contract(pure=true)
    public static @NotNull com.viaversion.viaversion.libs.kyori.adventure.text.SelectorComponent$Builder selector() {
        return new SelectorComponentImpl$BuilderImpl();
    }

    @Contract(pure=true)
    public static @NotNull com.viaversion.viaversion.libs.kyori.adventure.text.StorageNBTComponent$Builder storageNBT() {
        return new StorageNBTComponentImpl$BuilderImpl();
    }

    @Contract(pure=true)
    public static @NotNull com.viaversion.viaversion.libs.kyori.adventure.text.TextComponent$Builder text() {
        return new TextComponentImpl$BuilderImpl();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static TextComponent text(@NotNull String string) {
        if (string.isEmpty()) {
            return Component.empty();
        }
        return Component.text(string, Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(@NotNull String string, @NotNull Style style) {
        return TextComponentImpl.create(Collections.emptyList(), Objects.requireNonNull(style, "style"), string);
    }

    @Contract(pure=true)
    public static @NotNull com.viaversion.viaversion.libs.kyori.adventure.text.TranslatableComponent$Builder translatable() {
        return new TranslatableComponentImpl$BuilderImpl();
    }

    public @Unmodifiable @NotNull List<Component> children();

    @Contract(pure=true)
    @NotNull
    public Component children(@NotNull List<? extends ComponentLike> var1);

    @NotNull
    public Style style();

    @Contract(pure=true)
    @NotNull
    public Component style(@NotNull Style var1);

    @Contract(pure=true)
    @NotNull
    default public Component style(@NotNull Consumer<Style$Builder> consumer) {
        return this.style(this.style().edit(consumer));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Component decoration(@NotNull TextDecoration textDecoration, boolean bl2) {
        return (Component)StyleSetter.super.decoration(textDecoration, bl2);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Component decoration(@NotNull TextDecoration textDecoration, @NotNull TextDecoration$State textDecoration$State) {
        return this.style(this.style().decoration(textDecoration, textDecoration$State));
    }

    default public boolean hasStyling() {
        return !this.style().isEmpty();
    }

    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull TextReplacementConfig textReplacementConfig) {
        Objects.requireNonNull(textReplacementConfig, "replacement");
        if (!(textReplacementConfig instanceof TextReplacementConfigImpl)) {
            throw new IllegalArgumentException("Provided replacement was a custom TextReplacementConfig implementation, which is not supported.");
        }
        return TextReplacementRenderer.INSTANCE.render(this, ((TextReplacementConfigImpl)textReplacementConfig).createState());
    }

    @Override
    @NotNull
    default public Component asComponent() {
        return this;
    }

    @Override
    @NotNull
    default public HoverEvent<Component> asHoverEvent(@NotNull UnaryOperator<Component> unaryOperator) {
        return HoverEvent.showText((Component)unaryOperator.apply(this));
    }

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("style", this.style()), ExaminableProperty.of("children", this.children()));
    }
}

