/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.nbt;

import com.viaversion.viaversion.libs.kyori.adventure.nbt.BinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.ByteArrayBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.ByteBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.CharBuffer;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.CompoundBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.CompoundBinaryTag$Builder;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.DoubleBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.FloatBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.IntArrayBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.IntBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.ListBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.ListBinaryTag$Builder;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.LongArrayBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.LongBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.ShortBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.StringBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.Tokens;
import java.util.ArrayList;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

final class TagStringReader {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private final CharBuffer buffer;
    private boolean acceptLegacy;
    private int depth;

    TagStringReader(CharBuffer charBuffer) {
        this.buffer = charBuffer;
    }

    public CompoundBinaryTag compound() {
        this.buffer.expect('{');
        if (this.buffer.takeIf('}')) {
            return CompoundBinaryTag.empty();
        }
        CompoundBinaryTag$Builder compoundBinaryTag$Builder = CompoundBinaryTag.builder();
        while (this.buffer.hasMore()) {
            compoundBinaryTag$Builder.put(this.key(), this.tag());
            if (!this.separatorOrCompleteWith('}')) continue;
            return compoundBinaryTag$Builder.build();
        }
        throw this.buffer.makeError("Unterminated compound tag!");
    }

    public ListBinaryTag list() {
        boolean bl2;
        ListBinaryTag$Builder<BinaryTag> listBinaryTag$Builder = ListBinaryTag.builder();
        this.buffer.expect('[');
        boolean bl3 = bl2 = this.acceptLegacy && this.buffer.peek() == '0' && this.buffer.peek(1) == ':';
        if (!bl2 && this.buffer.takeIf(']')) {
            return ListBinaryTag.empty();
        }
        while (this.buffer.hasMore()) {
            if (bl2) {
                this.buffer.takeUntil(':');
            }
            BinaryTag binaryTag = this.tag();
            listBinaryTag$Builder.add(binaryTag);
            if (!this.separatorOrCompleteWith(']')) continue;
            return listBinaryTag$Builder.build();
        }
        throw this.buffer.makeError("Reached end of file without end of list tag!");
    }

    public BinaryTag array(char c2) {
        this.buffer.expect('[').expect(c2).expect(';');
        c2 = Character.toLowerCase(c2);
        if (c2 == 'b') {
            return ByteArrayBinaryTag.of(this.byteArray());
        }
        if (c2 == 'i') {
            return IntArrayBinaryTag.of(this.intArray());
        }
        if (c2 == 'l') {
            return LongArrayBinaryTag.of(this.longArray());
        }
        throw this.buffer.makeError("Type " + c2 + " is not a valid element type in an array!");
    }

    private byte[] byteArray() {
        if (this.buffer.takeIf(']')) {
            return EMPTY_BYTE_ARRAY;
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        while (this.buffer.hasMore()) {
            CharSequence charSequence = this.buffer.skipWhitespace().takeUntil('b');
            try {
                arrayList.add(Byte.valueOf(charSequence.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                throw this.buffer.makeError("All elements of a byte array must be bytes!");
            }
            if (!this.separatorOrCompleteWith(']')) continue;
            byte[] byArray = new byte[arrayList.size()];
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                byArray[i2] = (Byte)arrayList.get(i2);
            }
            return byArray;
        }
        throw this.buffer.makeError("Reached end of document without array close");
    }

    private int[] intArray() {
        if (this.buffer.takeIf(']')) {
            return EMPTY_INT_ARRAY;
        }
        IntStream.Builder builder = IntStream.builder();
        while (this.buffer.hasMore()) {
            BinaryTag binaryTag = this.tag();
            if (!(binaryTag instanceof IntBinaryTag)) {
                throw this.buffer.makeError("All elements of an int array must be ints!");
            }
            builder.add(((IntBinaryTag)binaryTag).intValue());
            if (!this.separatorOrCompleteWith(']')) continue;
            return builder.build().toArray();
        }
        throw this.buffer.makeError("Reached end of document without array close");
    }

    private long[] longArray() {
        if (this.buffer.takeIf(']')) {
            return EMPTY_LONG_ARRAY;
        }
        LongStream.Builder builder = LongStream.builder();
        while (this.buffer.hasMore()) {
            CharSequence charSequence = this.buffer.skipWhitespace().takeUntil('l');
            try {
                builder.add(Long.parseLong(charSequence.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                throw this.buffer.makeError("All elements of a long array must be longs!");
            }
            if (!this.separatorOrCompleteWith(']')) continue;
            return builder.build().toArray();
        }
        throw this.buffer.makeError("Reached end of document without array close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String key() {
        this.buffer.skipWhitespace();
        char c2 = this.buffer.peek();
        try {
            if (c2 == '\'' || c2 == '\"') {
                String string = TagStringReader.unescape(this.buffer.takeUntil(this.buffer.take()).toString());
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (this.buffer.hasMore()) {
                char c3 = this.buffer.peek();
                if (!Tokens.id(c3)) {
                    if (!this.acceptLegacy) break;
                    if (c3 == '\\') {
                        this.buffer.take();
                        continue;
                    }
                    if (c3 == ':') break;
                    stringBuilder.append(this.buffer.take());
                    continue;
                }
                stringBuilder.append(this.buffer.take());
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            this.buffer.expect(':');
        }
    }

    public BinaryTag tag() {
        if (this.depth++ > 512) {
            throw this.buffer.makeError("Exceeded maximum allowed depth of 512 when reading tag");
        }
        try {
            char c2 = this.buffer.skipWhitespace().peek();
            switch (c2) {
                case '{': {
                    CompoundBinaryTag compoundBinaryTag = this.compound();
                    return compoundBinaryTag;
                }
                case '[': {
                    if (this.buffer.hasMore(2) && this.buffer.peek(2) == ';') {
                        BinaryTag binaryTag = this.array(this.buffer.peek(1));
                        return binaryTag;
                    }
                    ListBinaryTag listBinaryTag = this.list();
                    return listBinaryTag;
                }
                case '\"': 
                case '\'': {
                    this.buffer.advance();
                    StringBinaryTag stringBinaryTag = StringBinaryTag.of(TagStringReader.unescape(this.buffer.takeUntil(c2).toString()));
                    return stringBinaryTag;
                }
            }
            BinaryTag binaryTag = this.scalar();
            return binaryTag;
        }
        finally {
            --this.depth;
        }
    }

    private BinaryTag scalar() {
        String string;
        block22: {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = -1;
            while (this.buffer.hasMore()) {
                n2 = this.buffer.peek();
                if (n2 == 92) {
                    this.buffer.advance();
                    n2 = this.buffer.take();
                } else {
                    if (!Tokens.id((char)n2)) break;
                    this.buffer.advance();
                }
                stringBuilder.append((char)n2);
                if (n3 != -1 || Tokens.numeric((char)n2)) continue;
                n3 = stringBuilder.length();
            }
            n2 = stringBuilder.length();
            string = stringBuilder.toString();
            if (n3 == n2 && n2 > 1) {
                char c2 = string.charAt(n2 - '\u0001');
                try {
                    switch (Character.toLowerCase(c2)) {
                        case 'b': {
                            return ByteBinaryTag.of(Byte.parseByte(string.substring(0, n2 - 1)));
                        }
                        case 's': {
                            return ShortBinaryTag.of(Short.parseShort(string.substring(0, n2 - 1)));
                        }
                        case 'i': {
                            return IntBinaryTag.of(Integer.parseInt(string.substring(0, n2 - 1)));
                        }
                        case 'l': {
                            return LongBinaryTag.of(Long.parseLong(string.substring(0, n2 - 1)));
                        }
                        case 'f': {
                            float f2 = Float.parseFloat(string.substring(0, n2 - 1));
                            if (!Float.isFinite(f2)) break;
                            return FloatBinaryTag.of(f2);
                        }
                        case 'd': {
                            double d2 = Double.parseDouble(string.substring(0, n2 - 1));
                            if (!Double.isFinite(d2)) break;
                            return DoubleBinaryTag.of(d2);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (n3 == -1) {
                try {
                    return IntBinaryTag.of(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (string.indexOf(46) == -1) break block22;
                    try {
                        return DoubleBinaryTag.of(Double.parseDouble(string));
                    }
                    catch (NumberFormatException numberFormatException2) {
                        // empty catch block
                    }
                }
            }
        }
        if (string.equalsIgnoreCase("true")) {
            return ByteBinaryTag.ONE;
        }
        if (string.equalsIgnoreCase("false")) {
            return ByteBinaryTag.ZERO;
        }
        return StringBinaryTag.of(string);
    }

    private boolean separatorOrCompleteWith(char c2) {
        if (this.buffer.takeIf(c2)) {
            return true;
        }
        this.buffer.expect(',');
        return this.buffer.takeIf(c2);
    }

    private static String unescape(String string) {
        int n2 = string.indexOf(92);
        if (n2 == -1) {
            return string;
        }
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        do {
            stringBuilder.append(string, n3, n2);
        } while ((n2 = string.indexOf(92, (n3 = n2 + 1) + 1)) != -1);
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public void legacy(boolean bl2) {
        this.acceptLegacy = bl2;
    }
}

