/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.nbt;

import com.viaversion.viaversion.libs.kyori.adventure.nbt.CharBuffer;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.CompoundBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.StringTagParseException;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.TagStringIO$Builder;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.TagStringReader;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.TagStringWriter;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class TagStringIO {
    private static final TagStringIO INSTANCE = new TagStringIO(new TagStringIO$Builder());
    private final boolean acceptLegacy;
    private final boolean emitLegacy;
    private final String indent;

    @NotNull
    public static TagStringIO get() {
        return INSTANCE;
    }

    private TagStringIO(@NotNull TagStringIO$Builder tagStringIO$Builder) {
        this.acceptLegacy = TagStringIO$Builder.access$000(tagStringIO$Builder);
        this.emitLegacy = TagStringIO$Builder.access$100(tagStringIO$Builder);
        this.indent = TagStringIO$Builder.access$200(tagStringIO$Builder);
    }

    public CompoundBinaryTag asCompound(String string) {
        try {
            CharBuffer charBuffer = new CharBuffer(string);
            TagStringReader tagStringReader = new TagStringReader(charBuffer);
            tagStringReader.legacy(this.acceptLegacy);
            CompoundBinaryTag compoundBinaryTag = tagStringReader.compound();
            if (charBuffer.skipWhitespace().hasMore()) {
                throw new IOException("Document had trailing content after first CompoundTag");
            }
            return compoundBinaryTag;
        }
        catch (StringTagParseException stringTagParseException) {
            throw new IOException(stringTagParseException);
        }
    }

    public String asString(CompoundBinaryTag compoundBinaryTag) {
        StringBuilder stringBuilder = new StringBuilder();
        try (TagStringWriter tagStringWriter = new TagStringWriter(stringBuilder, this.indent);){
            tagStringWriter.legacy(this.emitLegacy);
            tagStringWriter.writeTag(compoundBinaryTag);
        }
        return stringBuilder.toString();
    }
}

