/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.nbt;

import com.viaversion.viaversion.libs.kyori.adventure.nbt.AbstractBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.BinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.BinaryTagType;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.BinaryTagTypes;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.CompoundBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.NumberBinaryTag;
import com.viaversion.viaversion.libs.kyori.adventure.nbt.StringBinaryTag;
import com.viaversion.viaversion.libs.kyori.examination.ExaminableProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="\"CompoundBinaryTag[length=\" + this.tags.size() + \"]\"", childrenArray="this.tags.entrySet().toArray()", hasChildren="!this.tags.isEmpty()")
final class CompoundBinaryTagImpl
extends AbstractBinaryTag
implements CompoundBinaryTag {
    static final CompoundBinaryTag EMPTY = new CompoundBinaryTagImpl(Collections.emptyMap());
    private final Map<String, BinaryTag> tags;
    private final int hashCode;

    CompoundBinaryTagImpl(Map<String, BinaryTag> map) {
        this.tags = Collections.unmodifiableMap(map);
        this.hashCode = map.hashCode();
    }

    public boolean contains(@NotNull String string, @NotNull BinaryTagType<?> binaryTagType) {
        @Nullable BinaryTag binaryTag = this.tags.get(string);
        return binaryTag != null && binaryTagType.test(binaryTag.type());
    }

    @Override
    @NotNull
    public CompoundBinaryTag put(@NotNull String string, @NotNull BinaryTag binaryTag) {
        return this.edit(map -> map.put(string, binaryTag));
    }

    @Override
    public byte getByte(@NotNull String string, byte by2) {
        if (this.contains(string, BinaryTagTypes.BYTE)) {
            return ((NumberBinaryTag)this.tags.get(string)).byteValue();
        }
        return by2;
    }

    @Override
    @NotNull
    public String getString(@NotNull String string, @NotNull String string2) {
        if (this.contains(string, BinaryTagTypes.STRING)) {
            return ((StringBinaryTag)this.tags.get(string)).value();
        }
        return string2;
    }

    @Override
    @NotNull
    public CompoundBinaryTag getCompound(@NotNull String string, @NotNull CompoundBinaryTag compoundBinaryTag) {
        if (this.contains(string, BinaryTagTypes.COMPOUND)) {
            return (CompoundBinaryTag)this.tags.get(string);
        }
        return compoundBinaryTag;
    }

    private CompoundBinaryTag edit(Consumer<Map<String, BinaryTag>> consumer) {
        HashMap<String, BinaryTag> hashMap = new HashMap<String, BinaryTag>(this.tags);
        consumer.accept(hashMap);
        return new CompoundBinaryTagImpl(hashMap);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof CompoundBinaryTagImpl && this.tags.equals(((CompoundBinaryTagImpl)object).tags);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("tags", this.tags));
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, ? extends BinaryTag>> iterator() {
        return this.tags.entrySet().iterator();
    }

    @Override
    public void forEach(@NotNull Consumer<? super Map.Entry<String, ? extends BinaryTag>> consumer) {
        this.tags.entrySet().forEach(Objects.requireNonNull(consumer, "action"));
    }
}

