/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.kyori.adventure.key;

import com.viaversion.viaversion.libs.kyori.adventure.key.KeyImpl;
import com.viaversion.viaversion.libs.kyori.adventure.key.Keyed;
import com.viaversion.viaversion.libs.kyori.examination.Examinable;
import com.viaversion.viaversion.libs.kyori.examination.ExaminableProperty;
import java.util.Comparator;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public interface Key
extends Keyed,
Examinable,
Comparable<Key> {
    @NotNull
    public static Key key(@NotNull @Pattern(value="([a-z0-9_\\-.]+:)?[a-z0-9_\\-./]+") String string) {
        return Key.key(string, ':');
    }

    @NotNull
    public static Key key(@NotNull String string, char c2) {
        int n2 = string.indexOf(c2);
        String string2 = n2 >= 1 ? string.substring(0, n2) : "minecraft";
        String string3 = n2 >= 0 ? string.substring(n2 + 1) : string;
        return Key.key(string2, string3);
    }

    @NotNull
    public static Key key(@NotNull @Pattern(value="[a-z0-9_\\-.]+") String string, @NotNull @Pattern(value="[a-z0-9_\\-./]+") String string2) {
        return new KeyImpl(string, string2);
    }

    @NotNull
    public static Comparator<? super Key> comparator() {
        return KeyImpl.COMPARATOR;
    }

    public static boolean parseableNamespace(@NotNull String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Key.allowedInNamespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean parseableValue(@NotNull String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Key.allowedInValue(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean allowedInNamespace(char c2) {
        return KeyImpl.allowedInNamespace(c2);
    }

    public static boolean allowedInValue(char c2) {
        return KeyImpl.allowedInValue(c2);
    }

    @NotNull
    public String namespace();

    @NotNull
    public String value();

    @NotNull
    public String asString();

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("namespace", this.namespace()), ExaminableProperty.of("value", this.value()));
    }

    @Override
    default public int compareTo(@NotNull Key key) {
        return Key.comparator().compare(this, key);
    }

    @Override
    @NotNull
    default public Key key() {
        return this;
    }
}

