/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.objects;

import com.viaversion.viaversion.libs.fastutil.objects.ObjectIterator;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectSpliterator;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectSpliterators;
import java.util.Arrays;
import java.util.function.Consumer;

class ObjectSpliterators$SpliteratorFromIterator<K>
implements ObjectSpliterator<K> {
    private final ObjectIterator<? extends K> iter;
    final int characteristics;
    private final boolean knownSize;
    private long size = Long.MAX_VALUE;
    private int nextBatchSize = 1024;
    private ObjectSpliterator<K> delegate = null;

    ObjectSpliterators$SpliteratorFromIterator(ObjectIterator<? extends K> objectIterator, int n2) {
        this.iter = objectIterator;
        this.characteristics = 0 | n2;
        this.knownSize = false;
    }

    ObjectSpliterators$SpliteratorFromIterator(ObjectIterator<? extends K> objectIterator, long l2, int n2) {
        this.iter = objectIterator;
        this.knownSize = true;
        this.size = l2;
        this.characteristics = (n2 & 0x1000) != 0 ? 0 | n2 : 0x4040 | n2;
    }

    @Override
    public boolean tryAdvance(Consumer<? super K> consumer) {
        if (this.delegate != null) {
            boolean bl2 = this.delegate.tryAdvance(consumer);
            if (!bl2) {
                this.delegate = null;
            }
            return bl2;
        }
        if (!this.iter.hasNext()) {
            return false;
        }
        --this.size;
        consumer.accept(this.iter.next());
        return true;
    }

    @Override
    public void forEachRemaining(Consumer<? super K> consumer) {
        if (this.delegate != null) {
            this.delegate.forEachRemaining(consumer);
            this.delegate = null;
        }
        this.iter.forEachRemaining(consumer);
        this.size = 0L;
    }

    @Override
    public long estimateSize() {
        if (this.delegate != null) {
            return this.delegate.estimateSize();
        }
        if (!this.iter.hasNext()) {
            return 0L;
        }
        return this.knownSize && this.size >= 0L ? this.size : Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    protected ObjectSpliterator<K> makeForSplit(K[] KArray, int n2) {
        return ObjectSpliterators.wrap(KArray, 0, n2, this.characteristics);
    }

    @Override
    public ObjectSpliterator<K> trySplit() {
        if (!this.iter.hasNext()) {
            return null;
        }
        int n2 = this.knownSize && this.size > 0L ? (int)Math.min((long)this.nextBatchSize, this.size) : this.nextBatchSize;
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        while (n3 < n2 && this.iter.hasNext()) {
            objectArray[n3++] = this.iter.next();
            --this.size;
        }
        if (n2 < this.nextBatchSize && this.iter.hasNext()) {
            objectArray = Arrays.copyOf(objectArray, this.nextBatchSize);
            while (this.iter.hasNext() && n3 < this.nextBatchSize) {
                objectArray[n3++] = this.iter.next();
                --this.size;
            }
        }
        this.nextBatchSize = Math.min(0x2000000, this.nextBatchSize + 1024);
        ObjectSpliterator<Object> objectSpliterator = this.makeForSplit(objectArray, n3);
        if (!this.iter.hasNext()) {
            this.delegate = objectSpliterator;
            return objectSpliterator.trySplit();
        }
        return objectSpliterator;
    }
}

