/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.objects;

import com.viaversion.viaversion.libs.fastutil.Size64;
import com.viaversion.viaversion.libs.fastutil.objects.AbstractObjectList$IndexBasedSpliterator;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectArrays;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectCollection;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectListIterator;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectSpliterator;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectSpliterators;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public interface ObjectList<K>
extends ObjectCollection<K>,
Comparable<List<? extends K>>,
List<K> {
    @Override
    public ObjectListIterator<K> iterator();

    @Override
    default public ObjectSpliterator<K> spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractObjectList$IndexBasedSpliterator(this, 0);
        }
        return ObjectSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16464);
    }

    @Override
    public ObjectListIterator<K> listIterator();

    @Override
    public ObjectListIterator<K> listIterator(int var1);

    @Override
    public ObjectList<K> subList(int var1, int var2);

    public void getElements(int var1, Object[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(K[] KArray) {
        this.setElements(0, KArray);
    }

    default public void setElements(int n2, K[] KArray) {
        this.setElements(n2, KArray, 0, KArray.length);
    }

    default public void setElements(int n2, K[] KArray, int n3, int n4) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
        ObjectArrays.ensureOffsetLength(KArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        ListIterator listIterator = this.listIterator(n2);
        int n5 = 0;
        while (n5 < n4) {
            listIterator.next();
            listIterator.set(KArray[n3 + n5++]);
        }
    }

    @Override
    default public boolean addAll(int n2, ObjectList<? extends K> objectList) {
        return this.addAll(n2, objectList);
    }

    @Override
    default public boolean addAll(ObjectList<? extends K> objectList) {
        return this.addAll(this.size(), objectList);
    }

    @Override
    default public void sort(Comparator<? super K> comparator) {
        Object[] objectArray = this.toArray();
        if (comparator == null) {
            ObjectArrays.stableSort(objectArray);
        } else {
            ObjectArrays.stableSort(objectArray, comparator);
        }
        this.setElements(objectArray);
    }
}

