/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.objects;

import com.viaversion.viaversion.libs.fastutil.objects.AbstractObjectSet;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectArraySet$1;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectArraySet$Spliterator;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectArrays;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectIterator;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectSpliterator;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public class ObjectArraySet<K>
extends AbstractObjectSet<K>
implements Serializable,
Cloneable {
    protected transient Object[] a;
    protected int size;

    public ObjectArraySet(Object[] objectArray) {
        this.a = objectArray;
        this.size = objectArray.length;
    }

    public ObjectArraySet() {
        this.a = ObjectArrays.EMPTY_ARRAY;
    }

    private int findKey(Object object) {
        int n2 = this.size;
        while (n2-- != 0) {
            if (!Objects.equals(this.a[n2], object)) continue;
            return n2;
        }
        return -1;
    }

    @Override
    public ObjectIterator<K> iterator() {
        return new ObjectArraySet$1(this);
    }

    @Override
    public ObjectSpliterator<K> spliterator() {
        return new ObjectArraySet$Spliterator(this);
    }

    @Override
    public boolean contains(Object object) {
        return this.findKey(object) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(Object object) {
        int n2 = this.findKey(object);
        if (n2 == -1) {
            return false;
        }
        int n3 = this.size - n2 - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.a[n2 + i2] = this.a[n2 + i2 + 1];
        }
        --this.size;
        this.a[this.size] = null;
        return true;
    }

    @Override
    public boolean add(K k2) {
        int n2 = this.findKey(k2);
        if (n2 != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            Object[] objectArray = new Object[this.size == 0 ? 2 : this.size * 2];
            int n3 = this.size;
            while (n3-- != 0) {
                objectArray[n3] = this.a[n3];
            }
            this.a = objectArray;
        }
        this.a[this.size++] = k2;
        return true;
    }

    @Override
    public void clear() {
        Arrays.fill(this.a, 0, this.size, null);
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object[] toArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.a, n2, Object[].class);
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray == null) {
            objectArray = new Object[this.size];
        } else if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.a, 0, objectArray, 0, this.size);
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    public ObjectArraySet<K> clone() {
        ObjectArraySet objectArraySet;
        try {
            objectArraySet = (ObjectArraySet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        objectArraySet.a = (Object[])this.a.clone();
        return objectArraySet;
    }
}

