/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.objects;

import com.viaversion.viaversion.libs.fastutil.Arrays;
import com.viaversion.viaversion.libs.fastutil.objects.AbstractObjectList;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectArrayList$1;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectArrayList$Spliterator;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectArrayList$SubList;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectArrays;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectList;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectListIterator;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectSpliterator;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.stream.Collector;

public class ObjectArrayList<K>
extends AbstractObjectList<K>
implements Serializable,
Cloneable,
RandomAccess {
    protected final boolean wrapped;
    protected transient K[] a;
    protected int size;
    private static final Collector<Object, ?, ObjectArrayList<Object>> TO_LIST_COLLECTOR = Collector.of(ObjectArrayList::new, ObjectArrayList::add, ObjectArrayList::combine, new Collector.Characteristics[0]);

    private static final <K> K[] copyArraySafe(K[] KArray, int n2) {
        if (n2 == 0) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        return java.util.Arrays.copyOf(KArray, n2, Object[].class);
    }

    protected ObjectArrayList(K[] KArray, boolean bl2) {
        this.a = KArray;
        this.wrapped = bl2;
    }

    private void initArrayFromCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial capacity (" + n2 + ") is negative");
        }
        this.a = n2 == 0 ? ObjectArrays.EMPTY_ARRAY : new Object[n2];
    }

    public ObjectArrayList(int n2) {
        this.initArrayFromCapacity(n2);
        this.wrapped = false;
    }

    public ObjectArrayList() {
        this.a = ObjectArrays.DEFAULT_EMPTY_ARRAY;
        this.wrapped = false;
    }

    ObjectArrayList<K> combine(ObjectArrayList<? extends K> objectArrayList) {
        this.addAll(objectArrayList);
        return this;
    }

    private void grow(int n2) {
        if (n2 <= this.a.length) {
            return;
        }
        if (this.a != ObjectArrays.DEFAULT_EMPTY_ARRAY) {
            n2 = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)n2);
        } else if (n2 < 10) {
            n2 = 10;
        }
        if (this.wrapped) {
            this.a = ObjectArrays.forceCapacity(this.a, n2, this.size);
        } else {
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.a, 0, objectArray, 0, this.size);
            this.a = objectArray;
        }
        assert (this.size <= this.a.length);
    }

    @Override
    public void add(int n2, K k2) {
        this.ensureIndex(n2);
        this.grow(this.size + 1);
        if (n2 != this.size) {
            System.arraycopy(this.a, n2, this.a, n2 + 1, this.size - n2);
        }
        this.a[n2] = k2;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    @Override
    public boolean add(K k2) {
        this.grow(this.size + 1);
        this.a[this.size++] = k2;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public K get(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[n2];
    }

    @Override
    public int indexOf(Object object) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!Objects.equals(object, this.a[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n2 = this.size;
        while (n2-- != 0) {
            if (!Objects.equals(object, this.a[n2])) continue;
            return n2;
        }
        return -1;
    }

    @Override
    public K remove(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        K k2 = this.a[n2];
        --this.size;
        if (n2 != this.size) {
            System.arraycopy(this.a, n2 + 1, this.a, n2, this.size - n2);
        }
        this.a[this.size] = null;
        assert (this.size <= this.a.length);
        return k2;
    }

    @Override
    public boolean remove(Object object) {
        int n2 = this.indexOf(object);
        if (n2 == -1) {
            return false;
        }
        this.remove(n2);
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public K set(int n2, K k2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        K k3 = this.a[n2];
        this.a[n2] = k2;
        return k3;
    }

    @Override
    public void clear() {
        java.util.Arrays.fill(this.a, 0, this.size, null);
        this.size = 0;
        assert (this.size <= this.a.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public ObjectList<K> subList(int n2, int n3) {
        if (n2 == 0 && n3 == this.size()) {
            return this;
        }
        this.ensureIndex(n2);
        this.ensureIndex(n3);
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        return new ObjectArrayList$SubList(this, n2, n3);
    }

    @Override
    public void getElements(int n2, Object[] objectArray, int n3, int n4) {
        ObjectArrays.ensureOffsetLength(objectArray, n3, n4);
        System.arraycopy(this.a, n2, objectArray, n3, n4);
    }

    @Override
    public void removeElements(int n2, int n3) {
        Arrays.ensureFromTo(this.size, n2, n3);
        System.arraycopy(this.a, n3, this.a, n2, this.size - n3);
        this.size -= n3 - n2;
        int n4 = n3 - n2;
        while (n4-- != 0) {
            this.a[this.size + n4] = null;
        }
    }

    @Override
    public void setElements(int n2, K[] KArray, int n3, int n4) {
        this.ensureIndex(n2);
        ObjectArrays.ensureOffsetLength(KArray, n3, n4);
        if (n2 + n4 > this.size) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size + ")");
        }
        System.arraycopy(KArray, n3, this.a, n2, n4);
    }

    @Override
    public void forEach(Consumer<? super K> consumer) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            consumer.accept(this.a[i2]);
        }
    }

    @Override
    public boolean addAll(int n2, Collection<? extends K> collection) {
        if (collection instanceof ObjectList) {
            return this.addAll(n2, (ObjectList)collection);
        }
        this.ensureIndex(n2);
        int n3 = collection.size();
        if (n3 == 0) {
            return false;
        }
        this.grow(this.size + n3);
        System.arraycopy(this.a, n2, this.a, n2 + n3, this.size - n2);
        Iterator<K> iterator = collection.iterator();
        this.size += n3;
        while (n3-- != 0) {
            this.a[n2++] = iterator.next();
        }
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public boolean addAll(int n2, ObjectList<? extends K> objectList) {
        this.ensureIndex(n2);
        int n3 = objectList.size();
        if (n3 == 0) {
            return false;
        }
        this.grow(this.size + n3);
        System.arraycopy(this.a, n2, this.a, n2 + n3, this.size - n2);
        objectList.getElements(0, this.a, n2, n3);
        this.size += n3;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int n2;
        Object[] objectArray = this.a;
        int n3 = 0;
        for (n2 = 0; n2 < this.size; n2 += 1) {
            if (collection.contains(objectArray[n2])) continue;
            objectArray[n3++] = objectArray[n2];
        }
        java.util.Arrays.fill(objectArray, n3, this.size, null);
        n2 = this.size != n3 ? 1 : 0;
        this.size = n3;
        return n2 != 0;
    }

    @Override
    public Object[] toArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        return java.util.Arrays.copyOf(this.a, n2, Object[].class);
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray == null) {
            objectArray = new Object[this.size()];
        } else if (objectArray.length < this.size()) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size());
        }
        System.arraycopy(this.a, 0, objectArray, 0, this.size());
        if (objectArray.length > this.size()) {
            objectArray[this.size()] = null;
        }
        return objectArray;
    }

    @Override
    public ObjectListIterator<K> listIterator(int n2) {
        this.ensureIndex(n2);
        return new ObjectArrayList$1(this, n2);
    }

    @Override
    public ObjectSpliterator<K> spliterator() {
        return new ObjectArrayList$Spliterator(this);
    }

    @Override
    public void sort(Comparator<? super K> comparator) {
        if (comparator == null) {
            ObjectArrays.stableSort(this.a, 0, this.size);
        } else {
            ObjectArrays.stableSort(this.a, 0, this.size, comparator);
        }
    }

    public ObjectArrayList<K> clone() {
        ObjectArrayList<K> objectArrayList = null;
        if (this.getClass() == ObjectArrayList.class) {
            objectArrayList = new ObjectArrayList<K>(ObjectArrayList.copyArraySafe(this.a, this.size), false);
            objectArrayList.size = this.size;
        } else {
            try {
                objectArrayList = (ObjectArrayList<K>)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException);
            }
            objectArrayList.a = ObjectArrayList.copyArraySafe(this.a, this.size);
        }
        return objectArrayList;
    }

    public boolean equals(ObjectArrayList<K> objectArrayList) {
        if (objectArrayList == this) {
            return true;
        }
        int n2 = this.size();
        if (n2 != objectArrayList.size()) {
            return false;
        }
        K[] KArray = this.a;
        K[] KArray2 = objectArrayList.a;
        if (KArray == KArray2 && n2 == objectArrayList.size()) {
            return true;
        }
        while (n2-- != 0) {
            if (Objects.equals(KArray[n2], KArray2[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof List)) {
            return false;
        }
        if (object instanceof ObjectArrayList) {
            return this.equals((ObjectArrayList)object);
        }
        if (object instanceof ObjectArrayList$SubList) {
            return ((ObjectArrayList$SubList)object).equals(this);
        }
        return super.equals(object);
    }

    @Override
    public int compareTo(ObjectArrayList<? extends K> objectArrayList) {
        int n2;
        int n3 = this.size();
        int n4 = objectArrayList.size();
        K[] KArray = this.a;
        K[] KArray2 = objectArrayList.a;
        for (n2 = 0; n2 < n3 && n2 < n4; ++n2) {
            K k2 = KArray[n2];
            K k3 = KArray2[n2];
            int n5 = ((Comparable)k2).compareTo(k3);
            if (n5 == 0) continue;
            return n5;
        }
        return n2 < n4 ? -1 : (n2 < n3 ? 1 : 0);
    }

    @Override
    public int compareTo(List<? extends K> list) {
        if (list instanceof ObjectArrayList) {
            return this.compareTo((ObjectArrayList)list);
        }
        if (list instanceof ObjectArrayList$SubList) {
            return -((ObjectArrayList$SubList)list).compareTo(this);
        }
        return super.compareTo(list);
    }
}

