/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.objects;

import com.viaversion.viaversion.libs.fastutil.Hash;
import com.viaversion.viaversion.libs.fastutil.HashCommon;
import com.viaversion.viaversion.libs.fastutil.objects.AbstractObject2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.objects.Object2ObjectMap$FastEntrySet;
import com.viaversion.viaversion.libs.fastutil.objects.Object2ObjectOpenHashMap$1;
import com.viaversion.viaversion.libs.fastutil.objects.Object2ObjectOpenHashMap$KeySet;
import com.viaversion.viaversion.libs.fastutil.objects.Object2ObjectOpenHashMap$MapEntrySet;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectCollection;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public class Object2ObjectOpenHashMap<K, V>
extends AbstractObject2ObjectMap<K, V>
implements Hash,
Serializable,
Cloneable {
    protected transient K[] key;
    protected transient V[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Object2ObjectMap$FastEntrySet<K, V> entries;
    protected transient ObjectSet<K> keys;
    protected transient ObjectCollection<V> values;

    public Object2ObjectOpenHashMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = HashCommon.arraySize(n2, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = new Object[this.n + 1];
        this.value = new Object[this.n + 1];
    }

    public Object2ObjectOpenHashMap() {
        this(16, 0.75f);
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    public void ensureCapacity(int n2) {
        int n3 = HashCommon.arraySize(n2, this.f);
        if (n3 > this.n) {
            this.rehash(n3);
        }
    }

    private void tryCapacity(long l2) {
        int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / this.f))));
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private V removeEntry(int n2) {
        V v2 = this.value[n2];
        this.value[n2] = null;
        --this.size;
        this.shiftKeys(n2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return v2;
    }

    private V removeNullEntry() {
        this.containsNullKey = false;
        this.key[this.n] = null;
        V v2 = this.value[this.n];
        this.value[this.n] = null;
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return v2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(map.size());
        } else {
            this.tryCapacity(this.size() + map.size());
        }
        super.putAll(map);
    }

    private int find(K k2) {
        if (k2 == null) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(k2.hashCode()) & this.mask;
        K k3 = KArray[n2];
        if (k3 == null) {
            return -(n2 + 1);
        }
        if (k2.equals(k3)) {
            return n2;
        }
        do {
            if ((k3 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return -(n2 + 1);
        } while (!k2.equals(k3));
        return n2;
    }

    private void insert(int n2, K k2, V v2) {
        if (n2 == this.n) {
            this.containsNullKey = true;
        }
        this.key[n2] = k2;
        this.value[n2] = v2;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
    }

    @Override
    public V put(K k2, V v2) {
        int n2 = this.find(k2);
        if (n2 < 0) {
            this.insert(-n2 - 1, k2, v2);
            return (V)this.defRetValue;
        }
        V v3 = this.value[n2];
        this.value[n2] = v2;
        return v3;
    }

    protected final void shiftKeys(int n2) {
        K[] KArray = this.key;
        while (true) {
            K k2;
            int n3 = n2;
            n2 = n3 + 1 & this.mask;
            while (true) {
                if ((k2 = KArray[n2]) == null) {
                    KArray[n3] = null;
                    this.value[n3] = null;
                    return;
                }
                int n4 = HashCommon.mix(k2.hashCode()) & this.mask;
                if (n3 <= n2 ? n3 >= n4 || n4 > n2 : n3 >= n4 && n4 > n2) break;
                n2 = n2 + 1 & this.mask;
            }
            KArray[n3] = k2;
            this.value[n3] = this.value[n2];
        }
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return (V)this.defRetValue;
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(object.hashCode()) & this.mask;
        K k2 = KArray[n2];
        if (k2 == null) {
            return (V)this.defRetValue;
        }
        if (object.equals(k2)) {
            return this.removeEntry(n2);
        }
        do {
            if ((k2 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return (V)this.defRetValue;
        } while (!object.equals(k2));
        return this.removeEntry(n2);
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return (V)(this.containsNullKey ? this.value[this.n] : this.defRetValue);
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(object.hashCode()) & this.mask;
        K k2 = KArray[n2];
        if (k2 == null) {
            return (V)this.defRetValue;
        }
        if (object.equals(k2)) {
            return this.value[n2];
        }
        do {
            if ((k2 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return (V)this.defRetValue;
        } while (!object.equals(k2));
        return this.value[n2];
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return this.containsNullKey;
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(object.hashCode()) & this.mask;
        K k2 = KArray[n2];
        if (k2 == null) {
            return false;
        }
        if (object.equals(k2)) {
            return true;
        }
        do {
            if ((k2 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return false;
        } while (!object.equals(k2));
        return true;
    }

    @Override
    public boolean containsValue(Object object) {
        V[] VArray = this.value;
        K[] KArray = this.key;
        if (this.containsNullKey && Objects.equals(VArray[this.n], object)) {
            return true;
        }
        int n2 = this.n;
        while (n2-- != 0) {
            if (KArray[n2] == null || !Objects.equals(VArray[n2], object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V getOrDefault(Object object, V v2) {
        if (object == null) {
            return this.containsNullKey ? this.value[this.n] : v2;
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(object.hashCode()) & this.mask;
        K k2 = KArray[n2];
        if (k2 == null) {
            return v2;
        }
        if (object.equals(k2)) {
            return this.value[n2];
        }
        do {
            if ((k2 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return v2;
        } while (!object.equals(k2));
        return this.value[n2];
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        int n2 = this.find(k2);
        if (n2 >= 0) {
            return this.value[n2];
        }
        this.insert(-n2 - 1, k2, v2);
        return (V)this.defRetValue;
    }

    @Override
    public boolean remove(Object object, Object object2) {
        if (object == null) {
            if (this.containsNullKey && Objects.equals(object2, this.value[this.n])) {
                this.removeNullEntry();
                return true;
            }
            return false;
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(object.hashCode()) & this.mask;
        K k2 = KArray[n2];
        if (k2 == null) {
            return false;
        }
        if (object.equals(k2) && Objects.equals(object2, this.value[n2])) {
            this.removeEntry(n2);
            return true;
        }
        do {
            if ((k2 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return false;
        } while (!object.equals(k2) || !Objects.equals(object2, this.value[n2]));
        this.removeEntry(n2);
        return true;
    }

    @Override
    public boolean replace(K k2, V v2, V v3) {
        int n2 = this.find(k2);
        if (n2 < 0 || !Objects.equals(v2, this.value[n2])) {
            return false;
        }
        this.value[n2] = v3;
        return true;
    }

    @Override
    public V replace(K k2, V v2) {
        int n2 = this.find(k2);
        if (n2 < 0) {
            return (V)this.defRetValue;
        }
        V v3 = this.value[n2];
        this.value[n2] = v2;
        return v3;
    }

    @Override
    public V computeIfPresent(K k2, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        int n2 = this.find(k2);
        if (n2 < 0) {
            return (V)this.defRetValue;
        }
        if (this.value[n2] == null) {
            return (V)this.defRetValue;
        }
        V v2 = biFunction.apply(k2, this.value[n2]);
        if (v2 == null) {
            if (k2 == null) {
                this.removeNullEntry();
            } else {
                this.removeEntry(n2);
            }
            return (V)this.defRetValue;
        }
        this.value[n2] = v2;
        return this.value[n2];
    }

    @Override
    public V compute(K k2, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        int n2 = this.find(k2);
        V v2 = biFunction.apply(k2, n2 >= 0 ? (Object)this.value[n2] : null);
        if (v2 == null) {
            if (n2 >= 0) {
                if (k2 == null) {
                    this.removeNullEntry();
                } else {
                    this.removeEntry(n2);
                }
            }
            return (V)this.defRetValue;
        }
        V v3 = v2;
        if (n2 < 0) {
            this.insert(-n2 - 1, k2, v3);
            return v3;
        }
        this.value[n2] = v3;
        return this.value[n2];
    }

    @Override
    public V merge(K k2, V v2, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        Objects.requireNonNull(v2);
        int n2 = this.find(k2);
        if (n2 < 0 || this.value[n2] == null) {
            if (n2 < 0) {
                this.insert(-n2 - 1, k2, v2);
            } else {
                this.value[n2] = v2;
            }
            return v2;
        }
        V v3 = biFunction.apply(this.value[n2], v2);
        if (v3 == null) {
            if (k2 == null) {
                this.removeNullEntry();
            } else {
                this.removeEntry(n2);
            }
            return (V)this.defRetValue;
        }
        this.value[n2] = v3;
        return this.value[n2];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, null);
        Arrays.fill(this.value, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object2ObjectMap$FastEntrySet<K, V> object2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new Object2ObjectOpenHashMap$MapEntrySet(this, null);
        }
        return this.entries;
    }

    @Override
    public ObjectSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new Object2ObjectOpenHashMap$KeySet(this, null);
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new Object2ObjectOpenHashMap$1(this);
        }
        return this.values;
    }

    protected void rehash(int n2) {
        K[] KArray = this.key;
        V[] VArray = this.value;
        int n3 = n2 - 1;
        Object[] objectArray = new Object[n2 + 1];
        Object[] objectArray2 = new Object[n2 + 1];
        int n4 = this.n;
        int n5 = this.realSize();
        while (n5-- != 0) {
            while (KArray[--n4] == null) {
            }
            int n6 = HashCommon.mix(KArray[n4].hashCode()) & n3;
            if (objectArray[n6] != null) {
                while (objectArray[n6 = n6 + 1 & n3] != null) {
                }
            }
            objectArray[n6] = KArray[n4];
            objectArray2[n6] = VArray[n4];
        }
        objectArray2[n2] = VArray[this.n];
        this.n = n2;
        this.mask = n3;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = objectArray;
        this.value = objectArray2;
    }

    public Object2ObjectOpenHashMap<K, V> clone() {
        Object2ObjectOpenHashMap object2ObjectOpenHashMap;
        try {
            object2ObjectOpenHashMap = (Object2ObjectOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        object2ObjectOpenHashMap.keys = null;
        object2ObjectOpenHashMap.values = null;
        object2ObjectOpenHashMap.entries = null;
        object2ObjectOpenHashMap.containsNullKey = this.containsNullKey;
        object2ObjectOpenHashMap.key = (Object[])this.key.clone();
        object2ObjectOpenHashMap.value = (Object[])this.value.clone();
        return object2ObjectOpenHashMap;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.realSize();
        int n4 = 0;
        int n5 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == null) {
                ++n4;
            }
            if (this != this.key[n4]) {
                n5 = this.key[n4].hashCode();
            }
            if (this != this.value[n4]) {
                n5 ^= this.value[n4] == null ? 0 : this.value[n4].hashCode();
            }
            n2 += n5;
            ++n4;
        }
        if (this.containsNullKey) {
            n2 += this.value[this.n] == null ? 0 : this.value[this.n].hashCode();
        }
        return n2;
    }

    static /* synthetic */ int access$100(Object2ObjectOpenHashMap object2ObjectOpenHashMap) {
        return object2ObjectOpenHashMap.realSize();
    }

    static /* synthetic */ Object access$400(Object2ObjectOpenHashMap object2ObjectOpenHashMap) {
        return object2ObjectOpenHashMap.removeNullEntry();
    }

    static /* synthetic */ Object access$500(Object2ObjectOpenHashMap object2ObjectOpenHashMap, int n2) {
        return object2ObjectOpenHashMap.removeEntry(n2);
    }
}

