/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.objects;

import com.viaversion.viaversion.libs.fastutil.Hash;
import com.viaversion.viaversion.libs.fastutil.HashCommon;
import com.viaversion.viaversion.libs.fastutil.ints.IntCollection;
import com.viaversion.viaversion.libs.fastutil.objects.AbstractObject2IntMap;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntMap$FastEntrySet;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntOpenHashMap$1;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntOpenHashMap$KeySet;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntOpenHashMap$MapEntrySet;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class Object2IntOpenHashMap<K>
extends AbstractObject2IntMap<K>
implements Hash,
Serializable,
Cloneable {
    protected transient K[] key;
    protected transient int[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Object2IntMap$FastEntrySet<K> entries;
    protected transient ObjectSet<K> keys;
    protected transient IntCollection values;

    public Object2IntOpenHashMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = HashCommon.arraySize(n2, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = new Object[this.n + 1];
        this.value = new int[this.n + 1];
    }

    public Object2IntOpenHashMap(int n2) {
        this(n2, 0.75f);
    }

    public Object2IntOpenHashMap() {
        this(16, 0.75f);
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    public void ensureCapacity(int n2) {
        int n3 = HashCommon.arraySize(n2, this.f);
        if (n3 > this.n) {
            this.rehash(n3);
        }
    }

    private void tryCapacity(long l2) {
        int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / this.f))));
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private int removeEntry(int n2) {
        int n3 = this.value[n2];
        --this.size;
        this.shiftKeys(n2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return n3;
    }

    private int removeNullEntry() {
        this.containsNullKey = false;
        this.key[this.n] = null;
        int n2 = this.value[this.n];
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return n2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Integer> map) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(map.size());
        } else {
            this.tryCapacity(this.size() + map.size());
        }
        super.putAll(map);
    }

    private int find(K k2) {
        if (k2 == null) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(k2.hashCode()) & this.mask;
        K k3 = KArray[n2];
        if (k3 == null) {
            return -(n2 + 1);
        }
        if (k2.equals(k3)) {
            return n2;
        }
        do {
            if ((k3 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return -(n2 + 1);
        } while (!k2.equals(k3));
        return n2;
    }

    private void insert(int n2, K k2, int n3) {
        if (n2 == this.n) {
            this.containsNullKey = true;
        }
        this.key[n2] = k2;
        this.value[n2] = n3;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
    }

    @Override
    public int put(K k2, int n2) {
        int n3 = this.find(k2);
        if (n3 < 0) {
            this.insert(-n3 - 1, k2, n2);
            return this.defRetValue;
        }
        int n4 = this.value[n3];
        this.value[n3] = n2;
        return n4;
    }

    protected final void shiftKeys(int n2) {
        K[] KArray = this.key;
        while (true) {
            K k2;
            int n3 = n2;
            n2 = n3 + 1 & this.mask;
            while (true) {
                if ((k2 = KArray[n2]) == null) {
                    KArray[n3] = null;
                    return;
                }
                int n4 = HashCommon.mix(k2.hashCode()) & this.mask;
                if (n3 <= n2 ? n3 >= n4 || n4 > n2 : n3 >= n4 && n4 > n2) break;
                n2 = n2 + 1 & this.mask;
            }
            KArray[n3] = k2;
            this.value[n3] = this.value[n2];
        }
    }

    @Override
    public int removeInt(Object object) {
        if (object == null) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(object.hashCode()) & this.mask;
        K k2 = KArray[n2];
        if (k2 == null) {
            return this.defRetValue;
        }
        if (object.equals(k2)) {
            return this.removeEntry(n2);
        }
        do {
            if ((k2 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return this.defRetValue;
        } while (!object.equals(k2));
        return this.removeEntry(n2);
    }

    @Override
    public int getInt(Object object) {
        if (object == null) {
            return this.containsNullKey ? this.value[this.n] : this.defRetValue;
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(object.hashCode()) & this.mask;
        K k2 = KArray[n2];
        if (k2 == null) {
            return this.defRetValue;
        }
        if (object.equals(k2)) {
            return this.value[n2];
        }
        do {
            if ((k2 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return this.defRetValue;
        } while (!object.equals(k2));
        return this.value[n2];
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return this.containsNullKey;
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(object.hashCode()) & this.mask;
        K k2 = KArray[n2];
        if (k2 == null) {
            return false;
        }
        if (object.equals(k2)) {
            return true;
        }
        do {
            if ((k2 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return false;
        } while (!object.equals(k2));
        return true;
    }

    @Override
    public boolean containsValue(int n2) {
        int[] nArray = this.value;
        K[] KArray = this.key;
        if (this.containsNullKey && nArray[this.n] == n2) {
            return true;
        }
        int n3 = this.n;
        while (n3-- != 0) {
            if (KArray[n3] == null || nArray[n3] != n2) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getOrDefault(Object object, int n2) {
        if (object == null) {
            return this.containsNullKey ? this.value[this.n] : n2;
        }
        K[] KArray = this.key;
        int n3 = HashCommon.mix(object.hashCode()) & this.mask;
        K k2 = KArray[n3];
        if (k2 == null) {
            return n2;
        }
        if (object.equals(k2)) {
            return this.value[n3];
        }
        do {
            if ((k2 = KArray[n3 = n3 + 1 & this.mask]) != null) continue;
            return n2;
        } while (!object.equals(k2));
        return this.value[n3];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object2IntMap$FastEntrySet<K> object2IntEntrySet() {
        if (this.entries == null) {
            this.entries = new Object2IntOpenHashMap$MapEntrySet(this, null);
        }
        return this.entries;
    }

    @Override
    public ObjectSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new Object2IntOpenHashMap$KeySet(this, null);
        }
        return this.keys;
    }

    @Override
    public IntCollection values() {
        if (this.values == null) {
            this.values = new Object2IntOpenHashMap$1(this);
        }
        return this.values;
    }

    protected void rehash(int n2) {
        K[] KArray = this.key;
        int[] nArray = this.value;
        int n3 = n2 - 1;
        Object[] objectArray = new Object[n2 + 1];
        int[] nArray2 = new int[n2 + 1];
        int n4 = this.n;
        int n5 = this.realSize();
        while (n5-- != 0) {
            while (KArray[--n4] == null) {
            }
            int n6 = HashCommon.mix(KArray[n4].hashCode()) & n3;
            if (objectArray[n6] != null) {
                while (objectArray[n6 = n6 + 1 & n3] != null) {
                }
            }
            objectArray[n6] = KArray[n4];
            nArray2[n6] = nArray[n4];
        }
        nArray2[n2] = nArray[this.n];
        this.n = n2;
        this.mask = n3;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = objectArray;
        this.value = nArray2;
    }

    public Object2IntOpenHashMap<K> clone() {
        Object2IntOpenHashMap object2IntOpenHashMap;
        try {
            object2IntOpenHashMap = (Object2IntOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        object2IntOpenHashMap.keys = null;
        object2IntOpenHashMap.values = null;
        object2IntOpenHashMap.entries = null;
        object2IntOpenHashMap.containsNullKey = this.containsNullKey;
        object2IntOpenHashMap.key = (Object[])this.key.clone();
        object2IntOpenHashMap.value = (int[])this.value.clone();
        return object2IntOpenHashMap;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.realSize();
        int n4 = 0;
        int n5 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == null) {
                ++n4;
            }
            if (this != this.key[n4]) {
                n5 = this.key[n4].hashCode();
            }
            n2 += (n5 ^= this.value[n4]);
            ++n4;
        }
        if (this.containsNullKey) {
            n2 += this.value[this.n];
        }
        return n2;
    }

    static /* synthetic */ int access$100(Object2IntOpenHashMap object2IntOpenHashMap) {
        return object2IntOpenHashMap.realSize();
    }

    static /* synthetic */ int access$400(Object2IntOpenHashMap object2IntOpenHashMap) {
        return object2IntOpenHashMap.removeNullEntry();
    }

    static /* synthetic */ int access$500(Object2IntOpenHashMap object2IntOpenHashMap, int n2) {
        return object2IntOpenHashMap.removeEntry(n2);
    }
}

