/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.objects;

import com.viaversion.viaversion.libs.fastutil.objects.AbstractObjectCollection;
import com.viaversion.viaversion.libs.fastutil.objects.AbstractObjectList$1;
import com.viaversion.viaversion.libs.fastutil.objects.AbstractObjectList$ObjectRandomAccessSubList;
import com.viaversion.viaversion.libs.fastutil.objects.AbstractObjectList$ObjectSubList;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectArrays;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectIterator;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectList;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectListIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;

public abstract class AbstractObjectList<K>
extends AbstractObjectCollection<K>
implements ObjectList<K> {
    protected AbstractObjectList() {
    }

    protected void ensureIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int n2, K k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(K k2) {
        this.add(this.size(), k2);
        return true;
    }

    @Override
    public K remove(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public K set(int n2, K k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n2, Collection<? extends K> collection) {
        this.ensureIndex(n2);
        Iterator<K> iterator = collection.iterator();
        boolean bl2 = iterator.hasNext();
        while (iterator.hasNext()) {
            this.add(n2++, iterator.next());
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends K> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public ObjectListIterator<K> iterator() {
        return this.listIterator();
    }

    @Override
    public ObjectListIterator<K> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ObjectListIterator<K> listIterator(int n2) {
        this.ensureIndex(n2);
        return new AbstractObjectList$1(this, 0, n2);
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            Object e2 = listIterator.next();
            if (!Objects.equals(object, e2)) continue;
            return listIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator listIterator = this.listIterator(this.size());
        while (listIterator.hasPrevious()) {
            Object k2 = listIterator.previous();
            if (!Objects.equals(object, k2)) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public ObjectList<K> subList(int n2, int n3) {
        this.ensureIndex(n2);
        this.ensureIndex(n3);
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        return this instanceof RandomAccess ? new AbstractObjectList$ObjectRandomAccessSubList(this, n2, n3) : new AbstractObjectList$ObjectSubList(this, n2, n3);
    }

    @Override
    public void forEach(Consumer<? super K> consumer) {
        if (this instanceof RandomAccess) {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                consumer.accept(this.get(i2));
            }
        } else {
            ObjectList.super.forEach(consumer);
        }
    }

    @Override
    public void removeElements(int n2, int n3) {
        this.ensureIndex(n3);
        ListIterator listIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        while (n4-- != 0) {
            listIterator.next();
            listIterator.remove();
        }
    }

    @Override
    public void getElements(int n2, Object[] objectArray, int n3, int n4) {
        this.ensureIndex(n2);
        ObjectArrays.ensureOffsetLength(objectArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            int n5 = n2;
            while (n4-- != 0) {
                objectArray[n3++] = this.get(n5++);
            }
        } else {
            ListIterator listIterator = this.listIterator(n2);
            while (n4-- != 0) {
                objectArray[n3++] = listIterator.next();
            }
        }
    }

    @Override
    public void setElements(int n2, K[] KArray, int n3, int n4) {
        this.ensureIndex(n2);
        ObjectArrays.ensureOffsetLength(KArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.set(i2 + n2, KArray[i2 + n3]);
            }
        } else {
            ListIterator listIterator = this.listIterator(n2);
            int n5 = 0;
            while (n5 < n4) {
                listIterator.next();
                listIterator.set(KArray[n3 + n5++]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    @Override
    public Object[] toArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        Object[] objectArray = new Object[n2];
        this.getElements(0, objectArray, 0, n2);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n2 = this.size();
        if (TArray.length < n2) {
            TArray = Arrays.copyOf(TArray, n2);
        }
        this.getElements(0, TArray, 0, n2);
        if (TArray.length > n2) {
            TArray[n2] = null;
        }
        return TArray;
    }

    @Override
    public int hashCode() {
        ObjectIterator objectIterator = this.iterator();
        int n2 = 1;
        int n3 = this.size();
        while (n3-- != 0) {
            Object e2 = objectIterator.next();
            n2 = 31 * n2 + (e2 == null ? 0 : e2.hashCode());
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        int n2 = this.size();
        if (n2 != list.size()) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (n2-- != 0) {
            if (Objects.equals(listIterator.next(), listIterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends K> list) {
        if (list == this) {
            return 0;
        }
        if (list instanceof ObjectList) {
            ListIterator listIterator = this.listIterator();
            ListIterator listIterator2 = ((ObjectList)list).listIterator();
            while (listIterator.hasNext() && listIterator2.hasNext()) {
                Object e2;
                Object e3 = listIterator.next();
                int n2 = ((Comparable)e3).compareTo(e2 = listIterator2.next());
                if (n2 == 0) continue;
                return n2;
            }
            return listIterator2.hasNext() ? -1 : (listIterator.hasNext() ? 1 : 0);
        }
        ListIterator listIterator = this.listIterator();
        ListIterator<K> listIterator3 = list.listIterator();
        while (listIterator.hasNext() && listIterator3.hasNext()) {
            int n3 = ((Comparable)listIterator.next()).compareTo(listIterator3.next());
            if (n3 == 0) continue;
            return n3;
        }
        return listIterator3.hasNext() ? -1 : (listIterator.hasNext() ? 1 : 0);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ObjectIterator objectIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("[");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            Object e2 = objectIterator.next();
            if (this == e2) {
                stringBuilder.append("(this list)");
                continue;
            }
            stringBuilder.append(String.valueOf(e2));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

