/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.ints;

import com.viaversion.viaversion.libs.fastutil.ints.IntIterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntSpliterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntSpliterators;
import java.util.Arrays;
import java.util.function.IntConsumer;

class IntSpliterators$SpliteratorFromIterator
implements IntSpliterator {
    private final IntIterator iter;
    final int characteristics;
    private final boolean knownSize;
    private long size = Long.MAX_VALUE;
    private int nextBatchSize = 1024;
    private IntSpliterator delegate = null;

    IntSpliterators$SpliteratorFromIterator(IntIterator intIterator, int n2) {
        this.iter = intIterator;
        this.characteristics = 0x100 | n2;
        this.knownSize = false;
    }

    IntSpliterators$SpliteratorFromIterator(IntIterator intIterator, long l2, int n2) {
        this.iter = intIterator;
        this.knownSize = true;
        this.size = l2;
        this.characteristics = (n2 & 0x1000) != 0 ? 0x100 | n2 : 0x4140 | n2;
    }

    @Override
    public boolean tryAdvance(IntConsumer intConsumer) {
        if (this.delegate != null) {
            boolean bl2 = this.delegate.tryAdvance(intConsumer);
            if (!bl2) {
                this.delegate = null;
            }
            return bl2;
        }
        if (!this.iter.hasNext()) {
            return false;
        }
        --this.size;
        intConsumer.accept(this.iter.nextInt());
        return true;
    }

    @Override
    public void forEachRemaining(IntConsumer intConsumer) {
        if (this.delegate != null) {
            this.delegate.forEachRemaining(intConsumer);
            this.delegate = null;
        }
        this.iter.forEachRemaining(intConsumer);
        this.size = 0L;
    }

    @Override
    public long estimateSize() {
        if (this.delegate != null) {
            return this.delegate.estimateSize();
        }
        if (!this.iter.hasNext()) {
            return 0L;
        }
        return this.knownSize && this.size >= 0L ? this.size : Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    protected IntSpliterator makeForSplit(int[] nArray, int n2) {
        return IntSpliterators.wrap(nArray, 0, n2, this.characteristics);
    }

    @Override
    public IntSpliterator trySplit() {
        if (!this.iter.hasNext()) {
            return null;
        }
        int n2 = this.knownSize && this.size > 0L ? (int)Math.min((long)this.nextBatchSize, this.size) : this.nextBatchSize;
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2 && this.iter.hasNext()) {
            nArray[n3++] = this.iter.nextInt();
            --this.size;
        }
        if (n2 < this.nextBatchSize && this.iter.hasNext()) {
            nArray = Arrays.copyOf(nArray, this.nextBatchSize);
            while (this.iter.hasNext() && n3 < this.nextBatchSize) {
                nArray[n3++] = this.iter.nextInt();
                --this.size;
            }
        }
        this.nextBatchSize = Math.min(0x2000000, this.nextBatchSize + 1024);
        IntSpliterator intSpliterator = this.makeForSplit(nArray, n3);
        if (!this.iter.hasNext()) {
            this.delegate = intSpliterator;
            return intSpliterator.trySplit();
        }
        return intSpliterator;
    }
}

