/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.ints;

import com.viaversion.viaversion.libs.fastutil.Hash;
import com.viaversion.viaversion.libs.fastutil.HashCommon;
import com.viaversion.viaversion.libs.fastutil.ints.AbstractIntSet;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrays;
import com.viaversion.viaversion.libs.fastutil.ints.IntCollection;
import com.viaversion.viaversion.libs.fastutil.ints.IntIterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntOpenHashSet$SetIterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntOpenHashSet$SetSpliterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.IntConsumer;

public class IntOpenHashSet
extends AbstractIntSet
implements Hash,
Serializable,
Cloneable {
    protected transient int[] key;
    protected transient int mask;
    protected transient boolean containsNull;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;

    public IntOpenHashSet(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = HashCommon.arraySize(n2, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = new int[this.n + 1];
    }

    public IntOpenHashSet(int n2) {
        this(n2, 0.75f);
    }

    public IntOpenHashSet() {
        this(16, 0.75f);
    }

    public IntOpenHashSet(Collection<? extends Integer> collection, float f2) {
        this(collection.size(), f2);
        this.addAll(collection);
    }

    public IntOpenHashSet(Collection<? extends Integer> collection) {
        this(collection, 0.75f);
    }

    public IntOpenHashSet(int[] nArray, int n2, int n3, float f2) {
        this(n3 < 0 ? 0 : n3, f2);
        IntArrays.ensureOffsetLength(nArray, n2, n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.add(nArray[n2 + i2]);
        }
    }

    public IntOpenHashSet(int[] nArray, float f2) {
        this(nArray, 0, nArray.length, f2);
    }

    public IntOpenHashSet(int[] nArray) {
        this(nArray, 0.75f);
    }

    private int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    public void ensureCapacity(int n2) {
        int n3 = HashCommon.arraySize(n2, this.f);
        if (n3 > this.n) {
            this.rehash(n3);
        }
    }

    private void tryCapacity(long l2) {
        int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / this.f))));
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    @Override
    public boolean addAll(IntCollection intCollection) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(intCollection.size());
        } else {
            this.tryCapacity(this.size() + intCollection.size());
        }
        return super.addAll(intCollection);
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(collection.size());
        } else {
            this.tryCapacity(this.size() + collection.size());
        }
        return super.addAll(collection);
    }

    @Override
    public boolean add(int n2) {
        if (n2 == 0) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            int[] nArray = this.key;
            int n3 = HashCommon.mix(n2) & this.mask;
            int n4 = nArray[n3];
            if (n4 != 0) {
                if (n4 == n2) {
                    return false;
                }
                while ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) {
                    if (n4 != n2) continue;
                    return false;
                }
            }
            nArray[n3] = n2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    protected final void shiftKeys(int n2) {
        int[] nArray = this.key;
        while (true) {
            int n3;
            int n4 = n2;
            n2 = n4 + 1 & this.mask;
            while (true) {
                if ((n3 = nArray[n2]) == 0) {
                    nArray[n4] = 0;
                    return;
                }
                int n5 = HashCommon.mix(n3) & this.mask;
                if (n4 <= n2 ? n4 >= n5 || n5 > n2 : n4 >= n5 && n5 > n2) break;
                n2 = n2 + 1 & this.mask;
            }
            nArray[n4] = n3;
        }
    }

    private boolean removeEntry(int n2) {
        --this.size;
        this.shiftKeys(n2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    private boolean removeNullEntry() {
        this.containsNull = false;
        this.key[this.n] = 0;
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    @Override
    public boolean remove(int n2) {
        if (n2 == 0) {
            if (this.containsNull) {
                return this.removeNullEntry();
            }
            return false;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return false;
        }
        if (n2 == n4) {
            return this.removeEntry(n3);
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return false;
        } while (n2 != n4);
        return this.removeEntry(n3);
    }

    @Override
    public boolean contains(int n2) {
        if (n2 == 0) {
            return this.containsNull;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return false;
        }
        if (n2 == n4) {
            return true;
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return false;
        } while (n2 != n4);
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.key, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public IntIterator iterator() {
        return new IntOpenHashSet$SetIterator(this, null);
    }

    @Override
    public IntSpliterator spliterator() {
        return new IntOpenHashSet$SetSpliterator(this);
    }

    @Override
    public void forEach(IntConsumer intConsumer) {
        if (this.containsNull) {
            intConsumer.accept(this.key[this.n]);
        }
        int[] nArray = this.key;
        int n2 = this.n;
        while (n2-- != 0) {
            if (nArray[n2] == 0) continue;
            intConsumer.accept(nArray[n2]);
        }
    }

    protected void rehash(int n2) {
        int[] nArray = this.key;
        int n3 = n2 - 1;
        int[] nArray2 = new int[n2 + 1];
        int n4 = this.n;
        int n5 = this.realSize();
        while (n5-- != 0) {
            while (nArray[--n4] == 0) {
            }
            int n6 = HashCommon.mix(nArray[n4]) & n3;
            if (nArray2[n6] != 0) {
                while (nArray2[n6 = n6 + 1 & n3] != 0) {
                }
            }
            nArray2[n6] = nArray[n4];
        }
        this.n = n2;
        this.mask = n3;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = nArray2;
    }

    public IntOpenHashSet clone() {
        IntOpenHashSet intOpenHashSet;
        try {
            intOpenHashSet = (IntOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        intOpenHashSet.key = (int[])this.key.clone();
        intOpenHashSet.containsNull = this.containsNull;
        return intOpenHashSet;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.realSize();
        int n4 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == 0) {
                ++n4;
            }
            n2 += this.key[n4];
            ++n4;
        }
        return n2;
    }

    static /* synthetic */ int access$100(IntOpenHashSet intOpenHashSet) {
        return intOpenHashSet.realSize();
    }
}

