/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.ints;

import com.viaversion.viaversion.libs.fastutil.Size64;
import com.viaversion.viaversion.libs.fastutil.ints.AbstractIntList$IndexBasedSpliterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrays;
import com.viaversion.viaversion.libs.fastutil.ints.IntCollection;
import com.viaversion.viaversion.libs.fastutil.ints.IntComparator;
import com.viaversion.viaversion.libs.fastutil.ints.IntComparators;
import com.viaversion.viaversion.libs.fastutil.ints.IntListIterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntSpliterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntSpliterators;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;

public interface IntList
extends IntCollection,
Comparable<List<? extends Integer>>,
List<Integer> {
    @Override
    public IntListIterator iterator();

    @Override
    default public IntSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractIntList$IndexBasedSpliterator(this, 0);
        }
        return IntSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public IntListIterator listIterator();

    public IntListIterator listIterator(int var1);

    public IntList subList(int var1, int var2);

    public void getElements(int var1, int[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(int[] nArray) {
        this.setElements(0, nArray);
    }

    default public void setElements(int n2, int[] nArray) {
        this.setElements(n2, nArray, 0, nArray.length);
    }

    default public void setElements(int n2, int[] nArray, int n3, int n4) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
        IntArrays.ensureOffsetLength(nArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        IntListIterator intListIterator = this.listIterator(n2);
        int n5 = 0;
        while (n5 < n4) {
            intListIterator.nextInt();
            intListIterator.set(nArray[n3 + n5++]);
        }
    }

    @Override
    public boolean add(int var1);

    @Override
    public void add(int var1, int var2);

    @Override
    @Deprecated
    default public void add(int n2, Integer n3) {
        this.add(n2, (int)n3);
    }

    @Override
    public int set(int var1, int var2);

    default public void replaceAll(IntUnaryOperator intUnaryOperator) {
        IntListIterator intListIterator = this.listIterator();
        while (intListIterator.hasNext()) {
            intListIterator.set(intUnaryOperator.applyAsInt(intListIterator.nextInt()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Integer> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        this.replaceAll(unaryOperator instanceof IntUnaryOperator ? (IntUnaryOperator)((Object)unaryOperator) : unaryOperator::apply);
    }

    public int getInt(int var1);

    public int indexOf(int var1);

    public int lastIndexOf(int var1);

    @Override
    @Deprecated
    default public boolean contains(Object object) {
        return IntCollection.super.contains(object);
    }

    @Override
    @Deprecated
    default public Integer get(int n2) {
        return this.getInt(n2);
    }

    @Override
    @Deprecated
    default public int indexOf(Object object) {
        return this.indexOf((Integer)object);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object object) {
        return this.lastIndexOf((Integer)object);
    }

    @Override
    @Deprecated
    default public boolean add(Integer n2) {
        return this.add((int)n2);
    }

    public int removeInt(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object object) {
        return IntCollection.super.remove(object);
    }

    @Override
    @Deprecated
    default public Integer remove(int n2) {
        return this.removeInt(n2);
    }

    @Override
    @Deprecated
    default public Integer set(int n2, Integer n3) {
        return this.set(n2, (int)n3);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Integer> comparator) {
        this.sort(IntComparators.asIntComparator(comparator));
    }

    default public void sort(IntComparator intComparator) {
        if (intComparator == null) {
            this.unstableSort(intComparator);
        } else {
            int[] nArray = this.toIntArray();
            IntArrays.stableSort(nArray, intComparator);
            this.setElements(nArray);
        }
    }

    default public void unstableSort(IntComparator intComparator) {
        int[] nArray = this.toIntArray();
        if (intComparator == null) {
            IntArrays.unstableSort(nArray);
        } else {
            IntArrays.unstableSort(nArray, intComparator);
        }
        this.setElements(nArray);
    }
}

