/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.ints;

import com.viaversion.viaversion.libs.fastutil.Hash;
import com.viaversion.viaversion.libs.fastutil.HashCommon;
import com.viaversion.viaversion.libs.fastutil.Size64;
import com.viaversion.viaversion.libs.fastutil.ints.AbstractIntSortedSet;
import com.viaversion.viaversion.libs.fastutil.ints.IntCollection;
import com.viaversion.viaversion.libs.fastutil.ints.IntComparator;
import com.viaversion.viaversion.libs.fastutil.ints.IntLinkedOpenHashSet$SetIterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntListIterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntSortedSet;
import com.viaversion.viaversion.libs.fastutil.ints.IntSpliterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntSpliterators;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.function.IntConsumer;

public class IntLinkedOpenHashSet
extends AbstractIntSortedSet
implements Hash,
Serializable,
Cloneable {
    protected transient int[] key;
    protected transient int mask;
    protected transient boolean containsNull;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;

    public IntLinkedOpenHashSet(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = HashCommon.arraySize(n2, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = new int[this.n + 1];
        this.link = new long[this.n + 1];
    }

    public IntLinkedOpenHashSet() {
        this(16, 0.75f);
    }

    private int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    public void ensureCapacity(int n2) {
        int n3 = HashCommon.arraySize(n2, this.f);
        if (n3 > this.n) {
            this.rehash(n3);
        }
    }

    private void tryCapacity(long l2) {
        int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / this.f))));
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    @Override
    public boolean addAll(IntCollection intCollection) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(intCollection.size());
        } else {
            this.tryCapacity(this.size() + intCollection.size());
        }
        return super.addAll(intCollection);
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(collection.size());
        } else {
            this.tryCapacity(this.size() + collection.size());
        }
        return super.addAll(collection);
    }

    @Override
    public boolean add(int n2) {
        int n3;
        if (n2 == 0) {
            if (this.containsNull) {
                return false;
            }
            n3 = this.n;
            this.containsNull = true;
        } else {
            int[] nArray = this.key;
            n3 = HashCommon.mix(n2) & this.mask;
            int n4 = nArray[n3];
            if (n4 != 0) {
                if (n4 == n2) {
                    return false;
                }
                while ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) {
                    if (n4 != n2) continue;
                    return false;
                }
            }
            nArray[n3] = n2;
        }
        if (this.size == 0) {
            this.first = this.last = n3;
            this.link[n3] = -1L;
        } else {
            int n5 = this.last;
            this.link[n5] = this.link[n5] ^ (this.link[this.last] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n3] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = n3;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    protected final void shiftKeys(int n2) {
        int[] nArray = this.key;
        while (true) {
            int n3;
            int n4 = n2;
            n2 = n4 + 1 & this.mask;
            while (true) {
                if ((n3 = nArray[n2]) == 0) {
                    nArray[n4] = 0;
                    return;
                }
                int n5 = HashCommon.mix(n3) & this.mask;
                if (n4 <= n2 ? n4 >= n5 || n5 > n2 : n4 >= n5 && n5 > n2) break;
                n2 = n2 + 1 & this.mask;
            }
            nArray[n4] = n3;
            this.fixPointers(n2, n4);
        }
    }

    private boolean removeEntry(int n2) {
        --this.size;
        this.fixPointers(n2);
        this.shiftKeys(n2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    private boolean removeNullEntry() {
        this.containsNull = false;
        this.key[this.n] = 0;
        --this.size;
        this.fixPointers(this.n);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    @Override
    public boolean remove(int n2) {
        if (n2 == 0) {
            if (this.containsNull) {
                return this.removeNullEntry();
            }
            return false;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return false;
        }
        if (n2 == n4) {
            return this.removeEntry(n3);
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return false;
        } while (n2 != n4);
        return this.removeEntry(n3);
    }

    @Override
    public boolean contains(int n2) {
        if (n2 == 0) {
            return this.containsNull;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return false;
        }
        if (n2 == n4) {
            return true;
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return false;
        } while (n2 != n4);
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.key, 0);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    protected void fixPointers(int n2) {
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == n2) {
            this.first = (int)this.link[n2];
            if (0 <= this.first) {
                int n3 = this.first;
                this.link[n3] = this.link[n3] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == n2) {
            this.last = (int)(this.link[n2] >>> 32);
            if (0 <= this.last) {
                int n4 = this.last;
                this.link[n4] = this.link[n4] | 0xFFFFFFFFL;
            }
            return;
        }
        long l2 = this.link[n2];
        int n5 = (int)(l2 >>> 32);
        int n6 = (int)l2;
        int n7 = n5;
        this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n8 = n6;
        this.link[n8] = this.link[n8] ^ (this.link[n6] ^ l2 & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected void fixPointers(int n2, int n3) {
        if (this.size == 1) {
            this.first = this.last = n3;
            this.link[n3] = -1L;
            return;
        }
        if (this.first == n2) {
            this.first = n3;
            int n4 = (int)this.link[n2];
            this.link[n4] = this.link[n4] ^ (this.link[(int)this.link[n2]] ^ ((long)n3 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[n3] = this.link[n2];
            return;
        }
        if (this.last == n2) {
            this.last = n3;
            int n5 = (int)(this.link[n2] >>> 32);
            this.link[n5] = this.link[n5] ^ (this.link[(int)(this.link[n2] >>> 32)] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n3] = this.link[n2];
            return;
        }
        long l2 = this.link[n2];
        int n6 = (int)(l2 >>> 32);
        int n7 = (int)l2;
        int n8 = n6;
        this.link[n8] = this.link[n8] ^ (this.link[n6] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n9 = n7;
        this.link[n9] = this.link[n9] ^ (this.link[n7] ^ ((long)n3 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[n3] = l2;
    }

    @Override
    public int firstInt() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public int lastInt() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public IntSortedSet tailSet(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntSortedSet headSet(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntSortedSet subSet(int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntComparator comparator() {
        return null;
    }

    @Override
    public IntListIterator iterator() {
        return new IntLinkedOpenHashSet$SetIterator(this);
    }

    @Override
    public IntSpliterator spliterator() {
        return IntSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 337);
    }

    @Override
    public void forEach(IntConsumer intConsumer) {
        int n2 = this.first;
        while (n2 != -1) {
            int n3 = n2;
            n2 = (int)this.link[n3];
            intConsumer.accept(this.key[n3]);
        }
    }

    protected void rehash(int n2) {
        int[] nArray = this.key;
        int n3 = n2 - 1;
        int[] nArray2 = new int[n2 + 1];
        int n4 = this.first;
        int n5 = -1;
        int n6 = -1;
        long[] lArray = this.link;
        long[] lArray2 = new long[n2 + 1];
        this.first = -1;
        int n7 = this.size;
        while (n7-- != 0) {
            int n8;
            if (nArray[n4] == 0) {
                n8 = n2;
            } else {
                n8 = HashCommon.mix(nArray[n4]) & n3;
                while (nArray2[n8] != 0) {
                    n8 = n8 + 1 & n3;
                }
            }
            nArray2[n8] = nArray[n4];
            if (n5 != -1) {
                int n9 = n6;
                lArray2[n9] = lArray2[n9] ^ (lArray2[n6] ^ (long)n8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n10 = n8;
                lArray2[n10] = lArray2[n10] ^ (lArray2[n8] ^ ((long)n6 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                n6 = n8;
            } else {
                n6 = this.first = n8;
                lArray2[n8] = -1L;
            }
            int n11 = n4;
            n4 = (int)lArray[n4];
            n5 = n11;
        }
        this.link = lArray2;
        this.last = n6;
        if (n6 != -1) {
            int n12 = n6;
            lArray2[n12] = lArray2[n12] | 0xFFFFFFFFL;
        }
        this.n = n2;
        this.mask = n3;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = nArray2;
    }

    public IntLinkedOpenHashSet clone() {
        IntLinkedOpenHashSet intLinkedOpenHashSet;
        try {
            intLinkedOpenHashSet = (IntLinkedOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        intLinkedOpenHashSet.key = (int[])this.key.clone();
        intLinkedOpenHashSet.containsNull = this.containsNull;
        intLinkedOpenHashSet.link = (long[])this.link.clone();
        return intLinkedOpenHashSet;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.realSize();
        int n4 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == 0) {
                ++n4;
            }
            n2 += this.key[n4];
            ++n4;
        }
        return n2;
    }
}

