/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.ints;

import com.viaversion.viaversion.libs.fastutil.ints.AbstractIntSet;
import com.viaversion.viaversion.libs.fastutil.ints.IntArraySet$1;
import com.viaversion.viaversion.libs.fastutil.ints.IntArraySet$Spliterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrays;
import com.viaversion.viaversion.libs.fastutil.ints.IntIterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntSpliterator;
import java.io.Serializable;
import java.util.Arrays;

public class IntArraySet
extends AbstractIntSet
implements Serializable,
Cloneable {
    protected transient int[] a;
    protected int size;

    public IntArraySet(int[] nArray) {
        this.a = nArray;
        this.size = nArray.length;
    }

    public IntArraySet() {
        this.a = IntArrays.EMPTY_ARRAY;
    }

    private int findKey(int n2) {
        int n3 = this.size;
        while (n3-- != 0) {
            if (this.a[n3] != n2) continue;
            return n3;
        }
        return -1;
    }

    @Override
    public IntIterator iterator() {
        return new IntArraySet$1(this);
    }

    @Override
    public IntSpliterator spliterator() {
        return new IntArraySet$Spliterator(this);
    }

    @Override
    public boolean contains(int n2) {
        return this.findKey(n2) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(int n2) {
        int n3 = this.findKey(n2);
        if (n3 == -1) {
            return false;
        }
        int n4 = this.size - n3 - 1;
        for (int i2 = 0; i2 < n4; ++i2) {
            this.a[n3 + i2] = this.a[n3 + i2 + 1];
        }
        --this.size;
        return true;
    }

    @Override
    public boolean add(int n2) {
        int n3 = this.findKey(n2);
        if (n3 != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            int[] nArray = new int[this.size == 0 ? 2 : this.size * 2];
            int n4 = this.size;
            while (n4-- != 0) {
                nArray[n4] = this.a[n4];
            }
            this.a = nArray;
        }
        this.a[this.size++] = n2;
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int[] toIntArray() {
        if (this.size == 0) {
            return IntArrays.EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.a, this.size);
    }

    @Override
    public int[] toArray(int[] nArray) {
        if (nArray == null || nArray.length < this.size) {
            nArray = new int[this.size];
        }
        System.arraycopy(this.a, 0, nArray, 0, this.size);
        return nArray;
    }

    public IntArraySet clone() {
        IntArraySet intArraySet;
        try {
            intArraySet = (IntArraySet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        intArraySet.a = (int[])this.a.clone();
        return intArraySet;
    }
}

