/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.ints;

import com.viaversion.viaversion.libs.fastutil.Arrays;
import com.viaversion.viaversion.libs.fastutil.ints.AbstractIntList;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrayList$1;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrayList$Spliterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrayList$SubList;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrays;
import com.viaversion.viaversion.libs.fastutil.ints.IntCollection;
import com.viaversion.viaversion.libs.fastutil.ints.IntComparator;
import com.viaversion.viaversion.libs.fastutil.ints.IntIterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntList;
import com.viaversion.viaversion.libs.fastutil.ints.IntListIterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntSpliterator;
import java.io.Serializable;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.IntConsumer;

public class IntArrayList
extends AbstractIntList
implements Serializable,
Cloneable,
RandomAccess {
    protected transient int[] a;
    protected int size;

    private static final int[] copyArraySafe(int[] nArray, int n2) {
        if (n2 == 0) {
            return IntArrays.EMPTY_ARRAY;
        }
        return java.util.Arrays.copyOf(nArray, n2);
    }

    protected IntArrayList(int[] nArray, boolean bl2) {
        this.a = nArray;
    }

    private void initArrayFromCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial capacity (" + n2 + ") is negative");
        }
        this.a = n2 == 0 ? IntArrays.EMPTY_ARRAY : new int[n2];
    }

    public IntArrayList(int n2) {
        this.initArrayFromCapacity(n2);
    }

    public IntArrayList() {
        this.a = IntArrays.DEFAULT_EMPTY_ARRAY;
    }

    private void grow(int n2) {
        if (n2 <= this.a.length) {
            return;
        }
        if (this.a != IntArrays.DEFAULT_EMPTY_ARRAY) {
            n2 = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)n2);
        } else if (n2 < 10) {
            n2 = 10;
        }
        this.a = IntArrays.forceCapacity(this.a, n2, this.size);
        assert (this.size <= this.a.length);
    }

    @Override
    public void add(int n2, int n3) {
        this.ensureIndex(n2);
        this.grow(this.size + 1);
        if (n2 != this.size) {
            System.arraycopy(this.a, n2, this.a, n2 + 1, this.size - n2);
        }
        this.a[n2] = n3;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    @Override
    public boolean add(int n2) {
        this.grow(this.size + 1);
        this.a[this.size++] = n2;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public int getInt(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[n2];
    }

    @Override
    public int indexOf(int n2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (n2 != this.a[i2]) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int n2) {
        int n3 = this.size;
        while (n3-- != 0) {
            if (n2 != this.a[n3]) continue;
            return n3;
        }
        return -1;
    }

    @Override
    public int removeInt(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        int n3 = this.a[n2];
        --this.size;
        if (n2 != this.size) {
            System.arraycopy(this.a, n2 + 1, this.a, n2, this.size - n2);
        }
        assert (this.size <= this.a.length);
        return n3;
    }

    @Override
    public boolean rem(int n2) {
        int n3 = this.indexOf(n2);
        if (n3 == -1) {
            return false;
        }
        this.removeInt(n3);
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public int set(int n2, int n3) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        int n4 = this.a[n2];
        this.a[n2] = n3;
        return n4;
    }

    @Override
    public void clear() {
        this.size = 0;
        assert (this.size <= this.a.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public IntList subList(int n2, int n3) {
        if (n2 == 0 && n3 == this.size()) {
            return this;
        }
        this.ensureIndex(n2);
        this.ensureIndex(n3);
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        return new IntArrayList$SubList(this, n2, n3);
    }

    @Override
    public void getElements(int n2, int[] nArray, int n3, int n4) {
        IntArrays.ensureOffsetLength(nArray, n3, n4);
        System.arraycopy(this.a, n2, nArray, n3, n4);
    }

    @Override
    public void removeElements(int n2, int n3) {
        Arrays.ensureFromTo(this.size, n2, n3);
        System.arraycopy(this.a, n3, this.a, n2, this.size - n3);
        this.size -= n3 - n2;
    }

    @Override
    public void setElements(int n2, int[] nArray, int n3, int n4) {
        this.ensureIndex(n2);
        IntArrays.ensureOffsetLength(nArray, n3, n4);
        if (n2 + n4 > this.size) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size + ")");
        }
        System.arraycopy(nArray, n3, this.a, n2, n4);
    }

    @Override
    public void forEach(IntConsumer intConsumer) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            intConsumer.accept(this.a[i2]);
        }
    }

    @Override
    public boolean addAll(int n2, IntCollection intCollection) {
        if (intCollection instanceof IntList) {
            return this.addAll(n2, (IntList)intCollection);
        }
        this.ensureIndex(n2);
        int n3 = intCollection.size();
        if (n3 == 0) {
            return false;
        }
        this.grow(this.size + n3);
        System.arraycopy(this.a, n2, this.a, n2 + n3, this.size - n2);
        IntIterator intIterator = intCollection.iterator();
        this.size += n3;
        while (n3-- != 0) {
            this.a[n2++] = intIterator.nextInt();
        }
        assert (this.size <= this.a.length);
        return true;
    }

    public boolean addAll(int n2, IntList intList) {
        this.ensureIndex(n2);
        int n3 = intList.size();
        if (n3 == 0) {
            return false;
        }
        this.grow(this.size + n3);
        System.arraycopy(this.a, n2, this.a, n2 + n3, this.size - n2);
        intList.getElements(0, this.a, n2, n3);
        this.size += n3;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public boolean removeAll(IntCollection intCollection) {
        int n2;
        int[] nArray = this.a;
        int n3 = 0;
        for (n2 = 0; n2 < this.size; ++n2) {
            if (intCollection.contains(nArray[n2])) continue;
            nArray[n3++] = nArray[n2];
        }
        n2 = this.size != n3 ? 1 : 0;
        this.size = n3;
        return n2 != 0;
    }

    @Override
    public int[] toArray(int[] nArray) {
        if (nArray == null || nArray.length < this.size) {
            nArray = java.util.Arrays.copyOf(nArray, this.size);
        }
        System.arraycopy(this.a, 0, nArray, 0, this.size);
        return nArray;
    }

    @Override
    public IntListIterator listIterator(int n2) {
        this.ensureIndex(n2);
        return new IntArrayList$1(this, n2);
    }

    @Override
    public IntSpliterator spliterator() {
        return new IntArrayList$Spliterator(this);
    }

    @Override
    public void sort(IntComparator intComparator) {
        if (intComparator == null) {
            IntArrays.stableSort(this.a, 0, this.size);
        } else {
            IntArrays.stableSort(this.a, 0, this.size, intComparator);
        }
    }

    @Override
    public void unstableSort(IntComparator intComparator) {
        if (intComparator == null) {
            IntArrays.unstableSort(this.a, 0, this.size);
        } else {
            IntArrays.unstableSort(this.a, 0, this.size, intComparator);
        }
    }

    public IntArrayList clone() {
        IntArrayList intArrayList = null;
        if (this.getClass() == IntArrayList.class) {
            intArrayList = new IntArrayList(IntArrayList.copyArraySafe(this.a, this.size), false);
            intArrayList.size = this.size;
        } else {
            try {
                intArrayList = (IntArrayList)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException);
            }
            intArrayList.a = IntArrayList.copyArraySafe(this.a, this.size);
        }
        return intArrayList;
    }

    public boolean equals(IntArrayList intArrayList) {
        if (intArrayList == this) {
            return true;
        }
        int n2 = this.size();
        if (n2 != intArrayList.size()) {
            return false;
        }
        int[] nArray = this.a;
        int[] nArray2 = intArrayList.a;
        if (nArray == nArray2 && n2 == intArrayList.size()) {
            return true;
        }
        while (n2-- != 0) {
            if (nArray[n2] == nArray2[n2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof List)) {
            return false;
        }
        if (object instanceof IntArrayList) {
            return this.equals((IntArrayList)object);
        }
        if (object instanceof IntArrayList$SubList) {
            return ((IntArrayList$SubList)object).equals(this);
        }
        return super.equals(object);
    }

    @Override
    public int compareTo(IntArrayList intArrayList) {
        int n2;
        int n3 = this.size();
        int n4 = intArrayList.size();
        int[] nArray = this.a;
        int[] nArray2 = intArrayList.a;
        if (nArray == nArray2 && n3 == n4) {
            return 0;
        }
        for (n2 = 0; n2 < n3 && n2 < n4; ++n2) {
            int n5 = nArray[n2];
            int n6 = nArray2[n2];
            int n7 = Integer.compare(n5, n6);
            if (n7 == 0) continue;
            return n7;
        }
        return n2 < n4 ? -1 : (n2 < n3 ? 1 : 0);
    }

    @Override
    public int compareTo(List<? extends Integer> list) {
        if (list instanceof IntArrayList) {
            return this.compareTo((IntArrayList)list);
        }
        if (list instanceof IntArrayList$SubList) {
            return -((IntArrayList$SubList)list).compareTo(this);
        }
        return super.compareTo(list);
    }
}

