/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.ints;

import com.viaversion.viaversion.libs.fastutil.Hash;
import com.viaversion.viaversion.libs.fastutil.HashCommon;
import com.viaversion.viaversion.libs.fastutil.ints.AbstractInt2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectFunction;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap$FastEntrySet;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap$1;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap$KeySet;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap$MapEntrySet;
import com.viaversion.viaversion.libs.fastutil.ints.IntSet;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectCollection;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class Int2ObjectOpenHashMap<V>
extends AbstractInt2ObjectMap<V>
implements Hash,
Serializable,
Cloneable {
    protected transient int[] key;
    protected transient V[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Int2ObjectMap$FastEntrySet<V> entries;
    protected transient IntSet keys;
    protected transient ObjectCollection<V> values;

    public Int2ObjectOpenHashMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = HashCommon.arraySize(n2, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = new int[this.n + 1];
        this.value = new Object[this.n + 1];
    }

    public Int2ObjectOpenHashMap(int n2) {
        this(n2, 0.75f);
    }

    public Int2ObjectOpenHashMap() {
        this(16, 0.75f);
    }

    public Int2ObjectOpenHashMap(Map<? extends Integer, ? extends V> map, float f2) {
        this(map.size(), f2);
        this.putAll(map);
    }

    public Int2ObjectOpenHashMap(Map<? extends Integer, ? extends V> map) {
        this(map, 0.75f);
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    public void ensureCapacity(int n2) {
        int n3 = HashCommon.arraySize(n2, this.f);
        if (n3 > this.n) {
            this.rehash(n3);
        }
    }

    private void tryCapacity(long l2) {
        int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / this.f))));
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private V removeEntry(int n2) {
        V v2 = this.value[n2];
        this.value[n2] = null;
        --this.size;
        this.shiftKeys(n2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return v2;
    }

    private V removeNullEntry() {
        this.containsNullKey = false;
        V v2 = this.value[this.n];
        this.value[this.n] = null;
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return v2;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(map.size());
        } else {
            this.tryCapacity(this.size() + map.size());
        }
        super.putAll(map);
    }

    private int find(int n2) {
        if (n2 == 0) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return -(n3 + 1);
        }
        if (n2 == n4) {
            return n3;
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return -(n3 + 1);
        } while (n2 != n4);
        return n3;
    }

    private void insert(int n2, int n3, V v2) {
        if (n2 == this.n) {
            this.containsNullKey = true;
        }
        this.key[n2] = n3;
        this.value[n2] = v2;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
    }

    @Override
    public V put(int n2, V v2) {
        int n3 = this.find(n2);
        if (n3 < 0) {
            this.insert(-n3 - 1, n2, v2);
            return (V)this.defRetValue;
        }
        V v3 = this.value[n3];
        this.value[n3] = v2;
        return v3;
    }

    protected final void shiftKeys(int n2) {
        int[] nArray = this.key;
        while (true) {
            int n3;
            int n4 = n2;
            n2 = n4 + 1 & this.mask;
            while (true) {
                if ((n3 = nArray[n2]) == 0) {
                    nArray[n4] = 0;
                    this.value[n4] = null;
                    return;
                }
                int n5 = HashCommon.mix(n3) & this.mask;
                if (n4 <= n2 ? n4 >= n5 || n5 > n2 : n4 >= n5 && n5 > n2) break;
                n2 = n2 + 1 & this.mask;
            }
            nArray[n4] = n3;
            this.value[n4] = this.value[n2];
        }
    }

    @Override
    public V remove(int n2) {
        if (n2 == 0) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return (V)this.defRetValue;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return (V)this.defRetValue;
        }
        if (n2 == n4) {
            return this.removeEntry(n3);
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return (V)this.defRetValue;
        } while (n2 != n4);
        return this.removeEntry(n3);
    }

    @Override
    public V get(int n2) {
        if (n2 == 0) {
            return (V)(this.containsNullKey ? this.value[this.n] : this.defRetValue);
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return (V)this.defRetValue;
        }
        if (n2 == n4) {
            return this.value[n3];
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return (V)this.defRetValue;
        } while (n2 != n4);
        return this.value[n3];
    }

    @Override
    public boolean containsKey(int n2) {
        if (n2 == 0) {
            return this.containsNullKey;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return false;
        }
        if (n2 == n4) {
            return true;
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return false;
        } while (n2 != n4);
        return true;
    }

    @Override
    public boolean containsValue(Object object) {
        V[] VArray = this.value;
        int[] nArray = this.key;
        if (this.containsNullKey && Objects.equals(VArray[this.n], object)) {
            return true;
        }
        int n2 = this.n;
        while (n2-- != 0) {
            if (nArray[n2] == 0 || !Objects.equals(VArray[n2], object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V getOrDefault(int n2, V v2) {
        if (n2 == 0) {
            return this.containsNullKey ? this.value[this.n] : v2;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return v2;
        }
        if (n2 == n4) {
            return this.value[n3];
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return v2;
        } while (n2 != n4);
        return this.value[n3];
    }

    @Override
    public V computeIfAbsent(int n2, Int2ObjectFunction<? extends V> int2ObjectFunction) {
        Objects.requireNonNull(int2ObjectFunction);
        int n3 = this.find(n2);
        if (n3 >= 0) {
            return this.value[n3];
        }
        if (!int2ObjectFunction.containsKey(n2)) {
            return (V)this.defRetValue;
        }
        V v2 = int2ObjectFunction.get(n2);
        this.insert(-n3 - 1, n2, v2);
        return v2;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0);
        Arrays.fill(this.value, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Int2ObjectMap$FastEntrySet<V> int2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new Int2ObjectOpenHashMap$MapEntrySet(this, null);
        }
        return this.entries;
    }

    @Override
    public IntSet keySet() {
        if (this.keys == null) {
            this.keys = new Int2ObjectOpenHashMap$KeySet(this, null);
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new Int2ObjectOpenHashMap$1(this);
        }
        return this.values;
    }

    protected void rehash(int n2) {
        int[] nArray = this.key;
        V[] VArray = this.value;
        int n3 = n2 - 1;
        int[] nArray2 = new int[n2 + 1];
        Object[] objectArray = new Object[n2 + 1];
        int n4 = this.n;
        int n5 = this.realSize();
        while (n5-- != 0) {
            while (nArray[--n4] == 0) {
            }
            int n6 = HashCommon.mix(nArray[n4]) & n3;
            if (nArray2[n6] != 0) {
                while (nArray2[n6 = n6 + 1 & n3] != 0) {
                }
            }
            nArray2[n6] = nArray[n4];
            objectArray[n6] = VArray[n4];
        }
        objectArray[n2] = VArray[this.n];
        this.n = n2;
        this.mask = n3;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = nArray2;
        this.value = objectArray;
    }

    public Int2ObjectOpenHashMap<V> clone() {
        Int2ObjectOpenHashMap int2ObjectOpenHashMap;
        try {
            int2ObjectOpenHashMap = (Int2ObjectOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        int2ObjectOpenHashMap.keys = null;
        int2ObjectOpenHashMap.values = null;
        int2ObjectOpenHashMap.entries = null;
        int2ObjectOpenHashMap.containsNullKey = this.containsNullKey;
        int2ObjectOpenHashMap.key = (int[])this.key.clone();
        int2ObjectOpenHashMap.value = (Object[])this.value.clone();
        return int2ObjectOpenHashMap;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.realSize();
        int n4 = 0;
        int n5 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == 0) {
                ++n4;
            }
            n5 = this.key[n4];
            if (this != this.value[n4]) {
                n5 ^= this.value[n4] == null ? 0 : this.value[n4].hashCode();
            }
            n2 += n5;
            ++n4;
        }
        if (this.containsNullKey) {
            n2 += this.value[this.n] == null ? 0 : this.value[this.n].hashCode();
        }
        return n2;
    }

    static /* synthetic */ int access$100(Int2ObjectOpenHashMap int2ObjectOpenHashMap) {
        return int2ObjectOpenHashMap.realSize();
    }

    static /* synthetic */ Object access$400(Int2ObjectOpenHashMap int2ObjectOpenHashMap) {
        return int2ObjectOpenHashMap.removeNullEntry();
    }

    static /* synthetic */ Object access$500(Int2ObjectOpenHashMap int2ObjectOpenHashMap, int n2) {
        return int2ObjectOpenHashMap.removeEntry(n2);
    }
}

