/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.ints;

import com.viaversion.viaversion.libs.fastutil.Hash;
import com.viaversion.viaversion.libs.fastutil.HashCommon;
import com.viaversion.viaversion.libs.fastutil.ints.AbstractInt2ObjectSortedMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectFunction;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectLinkedOpenHashMap$1;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectLinkedOpenHashMap$KeySet;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectLinkedOpenHashMap$MapEntrySet;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectSortedMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectSortedMap$FastSortedEntrySet;
import com.viaversion.viaversion.libs.fastutil.ints.IntComparator;
import com.viaversion.viaversion.libs.fastutil.ints.IntSortedSet;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectCollection;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class Int2ObjectLinkedOpenHashMap<V>
extends AbstractInt2ObjectSortedMap<V>
implements Hash,
Serializable,
Cloneable {
    protected transient int[] key;
    protected transient V[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Int2ObjectSortedMap$FastSortedEntrySet<V> entries;
    protected transient IntSortedSet keys;
    protected transient ObjectCollection<V> values;

    public Int2ObjectLinkedOpenHashMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = HashCommon.arraySize(n2, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = new int[this.n + 1];
        this.value = new Object[this.n + 1];
        this.link = new long[this.n + 1];
    }

    public Int2ObjectLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Int2ObjectLinkedOpenHashMap(Int2ObjectMap<V> int2ObjectMap, float f2) {
        this(int2ObjectMap.size(), f2);
        this.putAll(int2ObjectMap);
    }

    public Int2ObjectLinkedOpenHashMap(Int2ObjectMap<V> int2ObjectMap) {
        this(int2ObjectMap, 0.75f);
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    public void ensureCapacity(int n2) {
        int n3 = HashCommon.arraySize(n2, this.f);
        if (n3 > this.n) {
            this.rehash(n3);
        }
    }

    private void tryCapacity(long l2) {
        int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / this.f))));
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private V removeEntry(int n2) {
        V v2 = this.value[n2];
        this.value[n2] = null;
        --this.size;
        this.fixPointers(n2);
        this.shiftKeys(n2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return v2;
    }

    private V removeNullEntry() {
        this.containsNullKey = false;
        V v2 = this.value[this.n];
        this.value[this.n] = null;
        --this.size;
        this.fixPointers(this.n);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return v2;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(map.size());
        } else {
            this.tryCapacity(this.size() + map.size());
        }
        super.putAll(map);
    }

    private int find(int n2) {
        if (n2 == 0) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return -(n3 + 1);
        }
        if (n2 == n4) {
            return n3;
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return -(n3 + 1);
        } while (n2 != n4);
        return n3;
    }

    private void insert(int n2, int n3, V v2) {
        if (n2 == this.n) {
            this.containsNullKey = true;
        }
        this.key[n2] = n3;
        this.value[n2] = v2;
        if (this.size == 0) {
            this.first = this.last = n2;
            this.link[n2] = -1L;
        } else {
            int n4 = this.last;
            this.link[n4] = this.link[n4] ^ (this.link[this.last] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = n2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
    }

    @Override
    public V put(int n2, V v2) {
        int n3 = this.find(n2);
        if (n3 < 0) {
            this.insert(-n3 - 1, n2, v2);
            return (V)this.defRetValue;
        }
        V v3 = this.value[n3];
        this.value[n3] = v2;
        return v3;
    }

    protected final void shiftKeys(int n2) {
        int[] nArray = this.key;
        while (true) {
            int n3;
            int n4 = n2;
            n2 = n4 + 1 & this.mask;
            while (true) {
                if ((n3 = nArray[n2]) == 0) {
                    nArray[n4] = 0;
                    this.value[n4] = null;
                    return;
                }
                int n5 = HashCommon.mix(n3) & this.mask;
                if (n4 <= n2 ? n4 >= n5 || n5 > n2 : n4 >= n5 && n5 > n2) break;
                n2 = n2 + 1 & this.mask;
            }
            nArray[n4] = n3;
            this.value[n4] = this.value[n2];
            this.fixPointers(n2, n4);
        }
    }

    @Override
    public V remove(int n2) {
        if (n2 == 0) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return (V)this.defRetValue;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return (V)this.defRetValue;
        }
        if (n2 == n4) {
            return this.removeEntry(n3);
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return (V)this.defRetValue;
        } while (n2 != n4);
        return this.removeEntry(n3);
    }

    @Override
    public V get(int n2) {
        if (n2 == 0) {
            return (V)(this.containsNullKey ? this.value[this.n] : this.defRetValue);
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return (V)this.defRetValue;
        }
        if (n2 == n4) {
            return this.value[n3];
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return (V)this.defRetValue;
        } while (n2 != n4);
        return this.value[n3];
    }

    @Override
    public boolean containsKey(int n2) {
        if (n2 == 0) {
            return this.containsNullKey;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return false;
        }
        if (n2 == n4) {
            return true;
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return false;
        } while (n2 != n4);
        return true;
    }

    @Override
    public boolean containsValue(Object object) {
        V[] VArray = this.value;
        int[] nArray = this.key;
        if (this.containsNullKey && Objects.equals(VArray[this.n], object)) {
            return true;
        }
        int n2 = this.n;
        while (n2-- != 0) {
            if (nArray[n2] == 0 || !Objects.equals(VArray[n2], object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V getOrDefault(int n2, V v2) {
        if (n2 == 0) {
            return this.containsNullKey ? this.value[this.n] : v2;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return v2;
        }
        if (n2 == n4) {
            return this.value[n3];
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return v2;
        } while (n2 != n4);
        return this.value[n3];
    }

    @Override
    public V computeIfAbsent(int n2, Int2ObjectFunction<? extends V> int2ObjectFunction) {
        Objects.requireNonNull(int2ObjectFunction);
        int n3 = this.find(n2);
        if (n3 >= 0) {
            return this.value[n3];
        }
        if (!int2ObjectFunction.containsKey(n2)) {
            return (V)this.defRetValue;
        }
        V v2 = int2ObjectFunction.get(n2);
        this.insert(-n3 - 1, n2, v2);
        return v2;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0);
        Arrays.fill(this.value, null);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    protected void fixPointers(int n2) {
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == n2) {
            this.first = (int)this.link[n2];
            if (0 <= this.first) {
                int n3 = this.first;
                this.link[n3] = this.link[n3] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == n2) {
            this.last = (int)(this.link[n2] >>> 32);
            if (0 <= this.last) {
                int n4 = this.last;
                this.link[n4] = this.link[n4] | 0xFFFFFFFFL;
            }
            return;
        }
        long l2 = this.link[n2];
        int n5 = (int)(l2 >>> 32);
        int n6 = (int)l2;
        int n7 = n5;
        this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n8 = n6;
        this.link[n8] = this.link[n8] ^ (this.link[n6] ^ l2 & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected void fixPointers(int n2, int n3) {
        if (this.size == 1) {
            this.first = this.last = n3;
            this.link[n3] = -1L;
            return;
        }
        if (this.first == n2) {
            this.first = n3;
            int n4 = (int)this.link[n2];
            this.link[n4] = this.link[n4] ^ (this.link[(int)this.link[n2]] ^ ((long)n3 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[n3] = this.link[n2];
            return;
        }
        if (this.last == n2) {
            this.last = n3;
            int n5 = (int)(this.link[n2] >>> 32);
            this.link[n5] = this.link[n5] ^ (this.link[(int)(this.link[n2] >>> 32)] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n3] = this.link[n2];
            return;
        }
        long l2 = this.link[n2];
        int n6 = (int)(l2 >>> 32);
        int n7 = (int)l2;
        int n8 = n6;
        this.link[n8] = this.link[n8] ^ (this.link[n6] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n9 = n7;
        this.link[n9] = this.link[n9] ^ (this.link[n7] ^ ((long)n3 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[n3] = l2;
    }

    @Override
    public int firstIntKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public int lastIntKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public Int2ObjectSortedMap<V> tailMap(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Int2ObjectSortedMap<V> headMap(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Int2ObjectSortedMap<V> subMap(int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntComparator comparator() {
        return null;
    }

    @Override
    public Int2ObjectSortedMap$FastSortedEntrySet<V> int2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new Int2ObjectLinkedOpenHashMap$MapEntrySet(this, null);
        }
        return this.entries;
    }

    @Override
    public IntSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new Int2ObjectLinkedOpenHashMap$KeySet(this, null);
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new Int2ObjectLinkedOpenHashMap$1(this);
        }
        return this.values;
    }

    protected void rehash(int n2) {
        int[] nArray = this.key;
        V[] VArray = this.value;
        int n3 = n2 - 1;
        int[] nArray2 = new int[n2 + 1];
        Object[] objectArray = new Object[n2 + 1];
        int n4 = this.first;
        int n5 = -1;
        int n6 = -1;
        long[] lArray = this.link;
        long[] lArray2 = new long[n2 + 1];
        this.first = -1;
        int n7 = this.size;
        while (n7-- != 0) {
            int n8;
            if (nArray[n4] == 0) {
                n8 = n2;
            } else {
                n8 = HashCommon.mix(nArray[n4]) & n3;
                while (nArray2[n8] != 0) {
                    n8 = n8 + 1 & n3;
                }
            }
            nArray2[n8] = nArray[n4];
            objectArray[n8] = VArray[n4];
            if (n5 != -1) {
                int n9 = n6;
                lArray2[n9] = lArray2[n9] ^ (lArray2[n6] ^ (long)n8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n10 = n8;
                lArray2[n10] = lArray2[n10] ^ (lArray2[n8] ^ ((long)n6 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                n6 = n8;
            } else {
                n6 = this.first = n8;
                lArray2[n8] = -1L;
            }
            int n11 = n4;
            n4 = (int)lArray[n4];
            n5 = n11;
        }
        this.link = lArray2;
        this.last = n6;
        if (n6 != -1) {
            int n12 = n6;
            lArray2[n12] = lArray2[n12] | 0xFFFFFFFFL;
        }
        this.n = n2;
        this.mask = n3;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = nArray2;
        this.value = objectArray;
    }

    public Int2ObjectLinkedOpenHashMap<V> clone() {
        Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap;
        try {
            int2ObjectLinkedOpenHashMap = (Int2ObjectLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        int2ObjectLinkedOpenHashMap.keys = null;
        int2ObjectLinkedOpenHashMap.values = null;
        int2ObjectLinkedOpenHashMap.entries = null;
        int2ObjectLinkedOpenHashMap.containsNullKey = this.containsNullKey;
        int2ObjectLinkedOpenHashMap.key = (int[])this.key.clone();
        int2ObjectLinkedOpenHashMap.value = (Object[])this.value.clone();
        int2ObjectLinkedOpenHashMap.link = (long[])this.link.clone();
        return int2ObjectLinkedOpenHashMap;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.realSize();
        int n4 = 0;
        int n5 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == 0) {
                ++n4;
            }
            n5 = this.key[n4];
            if (this != this.value[n4]) {
                n5 ^= this.value[n4] == null ? 0 : this.value[n4].hashCode();
            }
            n2 += n5;
            ++n4;
        }
        if (this.containsNullKey) {
            n2 += this.value[this.n] == null ? 0 : this.value[this.n].hashCode();
        }
        return n2;
    }

    static /* synthetic */ Object access$100(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap) {
        return int2ObjectLinkedOpenHashMap.removeNullEntry();
    }

    static /* synthetic */ Object access$200(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap, int n2) {
        return int2ObjectLinkedOpenHashMap.removeEntry(n2);
    }
}

