/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.ints;

import com.viaversion.viaversion.libs.fastutil.Hash;
import com.viaversion.viaversion.libs.fastutil.HashCommon;
import com.viaversion.viaversion.libs.fastutil.ints.AbstractInt2IntMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap$FastEntrySet;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntOpenHashMap$1;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntOpenHashMap$KeySet;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntOpenHashMap$MapEntrySet;
import com.viaversion.viaversion.libs.fastutil.ints.IntCollection;
import com.viaversion.viaversion.libs.fastutil.ints.IntSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class Int2IntOpenHashMap
extends AbstractInt2IntMap
implements Hash,
Serializable,
Cloneable {
    protected transient int[] key;
    protected transient int[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Int2IntMap$FastEntrySet entries;
    protected transient IntSet keys;
    protected transient IntCollection values;

    public Int2IntOpenHashMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = HashCommon.arraySize(n2, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = new int[this.n + 1];
        this.value = new int[this.n + 1];
    }

    public Int2IntOpenHashMap(int n2) {
        this(n2, 0.75f);
    }

    public Int2IntOpenHashMap() {
        this(16, 0.75f);
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    public void ensureCapacity(int n2) {
        int n3 = HashCommon.arraySize(n2, this.f);
        if (n3 > this.n) {
            this.rehash(n3);
        }
    }

    private void tryCapacity(long l2) {
        int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / this.f))));
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private int removeEntry(int n2) {
        int n3 = this.value[n2];
        --this.size;
        this.shiftKeys(n2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return n3;
    }

    private int removeNullEntry() {
        this.containsNullKey = false;
        int n2 = this.value[this.n];
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return n2;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> map) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(map.size());
        } else {
            this.tryCapacity(this.size() + map.size());
        }
        super.putAll(map);
    }

    private int find(int n2) {
        if (n2 == 0) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return -(n3 + 1);
        }
        if (n2 == n4) {
            return n3;
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return -(n3 + 1);
        } while (n2 != n4);
        return n3;
    }

    private void insert(int n2, int n3, int n4) {
        if (n2 == this.n) {
            this.containsNullKey = true;
        }
        this.key[n2] = n3;
        this.value[n2] = n4;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
    }

    @Override
    public int put(int n2, int n3) {
        int n4 = this.find(n2);
        if (n4 < 0) {
            this.insert(-n4 - 1, n2, n3);
            return this.defRetValue;
        }
        int n5 = this.value[n4];
        this.value[n4] = n3;
        return n5;
    }

    protected final void shiftKeys(int n2) {
        int[] nArray = this.key;
        while (true) {
            int n3;
            int n4 = n2;
            n2 = n4 + 1 & this.mask;
            while (true) {
                if ((n3 = nArray[n2]) == 0) {
                    nArray[n4] = 0;
                    return;
                }
                int n5 = HashCommon.mix(n3) & this.mask;
                if (n4 <= n2 ? n4 >= n5 || n5 > n2 : n4 >= n5 && n5 > n2) break;
                n2 = n2 + 1 & this.mask;
            }
            nArray[n4] = n3;
            this.value[n4] = this.value[n2];
        }
    }

    @Override
    public int remove(int n2) {
        if (n2 == 0) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return this.defRetValue;
        }
        if (n2 == n4) {
            return this.removeEntry(n3);
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return this.defRetValue;
        } while (n2 != n4);
        return this.removeEntry(n3);
    }

    @Override
    public int get(int n2) {
        if (n2 == 0) {
            return this.containsNullKey ? this.value[this.n] : this.defRetValue;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return this.defRetValue;
        }
        if (n2 == n4) {
            return this.value[n3];
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return this.defRetValue;
        } while (n2 != n4);
        return this.value[n3];
    }

    @Override
    public boolean containsKey(int n2) {
        if (n2 == 0) {
            return this.containsNullKey;
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return false;
        }
        if (n2 == n4) {
            return true;
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return false;
        } while (n2 != n4);
        return true;
    }

    @Override
    public boolean containsValue(int n2) {
        int[] nArray = this.value;
        int[] nArray2 = this.key;
        if (this.containsNullKey && nArray[this.n] == n2) {
            return true;
        }
        int n3 = this.n;
        while (n3-- != 0) {
            if (nArray2[n3] == 0 || nArray[n3] != n2) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getOrDefault(int n2, int n3) {
        if (n2 == 0) {
            return this.containsNullKey ? this.value[this.n] : n3;
        }
        int[] nArray = this.key;
        int n4 = HashCommon.mix(n2) & this.mask;
        int n5 = nArray[n4];
        if (n5 == 0) {
            return n3;
        }
        if (n2 == n5) {
            return this.value[n4];
        }
        do {
            if ((n5 = nArray[n4 = n4 + 1 & this.mask]) != 0) continue;
            return n3;
        } while (n2 != n5);
        return this.value[n4];
    }

    @Override
    public int putIfAbsent(int n2, int n3) {
        int n4 = this.find(n2);
        if (n4 >= 0) {
            return this.value[n4];
        }
        this.insert(-n4 - 1, n2, n3);
        return this.defRetValue;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Int2IntMap$FastEntrySet int2IntEntrySet() {
        if (this.entries == null) {
            this.entries = new Int2IntOpenHashMap$MapEntrySet(this, null);
        }
        return this.entries;
    }

    @Override
    public IntSet keySet() {
        if (this.keys == null) {
            this.keys = new Int2IntOpenHashMap$KeySet(this, null);
        }
        return this.keys;
    }

    @Override
    public IntCollection values() {
        if (this.values == null) {
            this.values = new Int2IntOpenHashMap$1(this);
        }
        return this.values;
    }

    protected void rehash(int n2) {
        int[] nArray = this.key;
        int[] nArray2 = this.value;
        int n3 = n2 - 1;
        int[] nArray3 = new int[n2 + 1];
        int[] nArray4 = new int[n2 + 1];
        int n4 = this.n;
        int n5 = this.realSize();
        while (n5-- != 0) {
            while (nArray[--n4] == 0) {
            }
            int n6 = HashCommon.mix(nArray[n4]) & n3;
            if (nArray3[n6] != 0) {
                while (nArray3[n6 = n6 + 1 & n3] != 0) {
                }
            }
            nArray3[n6] = nArray[n4];
            nArray4[n6] = nArray2[n4];
        }
        nArray4[n2] = nArray2[this.n];
        this.n = n2;
        this.mask = n3;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = nArray3;
        this.value = nArray4;
    }

    public Int2IntOpenHashMap clone() {
        Int2IntOpenHashMap int2IntOpenHashMap;
        try {
            int2IntOpenHashMap = (Int2IntOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        int2IntOpenHashMap.keys = null;
        int2IntOpenHashMap.values = null;
        int2IntOpenHashMap.entries = null;
        int2IntOpenHashMap.containsNullKey = this.containsNullKey;
        int2IntOpenHashMap.key = (int[])this.key.clone();
        int2IntOpenHashMap.value = (int[])this.value.clone();
        return int2IntOpenHashMap;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.realSize();
        int n4 = 0;
        int n5 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == 0) {
                ++n4;
            }
            n5 = this.key[n4];
            n2 += (n5 ^= this.value[n4]);
            ++n4;
        }
        if (this.containsNullKey) {
            n2 += this.value[this.n];
        }
        return n2;
    }

    static /* synthetic */ int access$100(Int2IntOpenHashMap int2IntOpenHashMap) {
        return int2IntOpenHashMap.realSize();
    }

    static /* synthetic */ int access$400(Int2IntOpenHashMap int2IntOpenHashMap) {
        return int2IntOpenHashMap.removeNullEntry();
    }

    static /* synthetic */ int access$500(Int2IntOpenHashMap int2IntOpenHashMap, int n2) {
        return int2IntOpenHashMap.removeEntry(n2);
    }
}

