/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.fastutil.ints;

import com.viaversion.viaversion.libs.fastutil.ints.AbstractIntCollection;
import com.viaversion.viaversion.libs.fastutil.ints.AbstractIntList$1;
import com.viaversion.viaversion.libs.fastutil.ints.AbstractIntList$IntRandomAccessSubList;
import com.viaversion.viaversion.libs.fastutil.ints.AbstractIntList$IntSubList;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrays;
import com.viaversion.viaversion.libs.fastutil.ints.IntCollection;
import com.viaversion.viaversion.libs.fastutil.ints.IntIterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntList;
import com.viaversion.viaversion.libs.fastutil.ints.IntListIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.IntConsumer;

public abstract class AbstractIntList
extends AbstractIntCollection
implements IntList {
    protected AbstractIntList() {
    }

    protected void ensureIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(int n2) {
        this.add(this.size(), n2);
        return true;
    }

    @Override
    public int removeInt(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int set(int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n2, Collection<? extends Integer> collection) {
        if (collection instanceof IntCollection) {
            return this.addAll(n2, (IntCollection)collection);
        }
        this.ensureIndex(n2);
        Iterator<? extends Integer> iterator = collection.iterator();
        boolean bl2 = iterator.hasNext();
        while (iterator.hasNext()) {
            this.add(n2++, (int)iterator.next());
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public IntListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public IntListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public IntListIterator listIterator(int n2) {
        this.ensureIndex(n2);
        return new AbstractIntList$1(this, 0, n2);
    }

    @Override
    public boolean contains(int n2) {
        return this.indexOf(n2) >= 0;
    }

    @Override
    public int indexOf(int n2) {
        IntListIterator intListIterator = this.listIterator();
        while (intListIterator.hasNext()) {
            int n3 = intListIterator.nextInt();
            if (n2 != n3) continue;
            return intListIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int n2) {
        IntListIterator intListIterator = this.listIterator(this.size());
        while (intListIterator.hasPrevious()) {
            int n3 = intListIterator.previousInt();
            if (n2 != n3) continue;
            return intListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public IntList subList(int n2, int n3) {
        this.ensureIndex(n2);
        this.ensureIndex(n3);
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        return this instanceof RandomAccess ? new AbstractIntList$IntRandomAccessSubList(this, n2, n3) : new AbstractIntList$IntSubList(this, n2, n3);
    }

    @Override
    public void forEach(IntConsumer intConsumer) {
        if (this instanceof RandomAccess) {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                intConsumer.accept(this.getInt(i2));
            }
        } else {
            IntList.super.forEach(intConsumer);
        }
    }

    @Override
    public void removeElements(int n2, int n3) {
        this.ensureIndex(n3);
        IntListIterator intListIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        while (n4-- != 0) {
            intListIterator.nextInt();
            intListIterator.remove();
        }
    }

    @Override
    public void getElements(int n2, int[] nArray, int n3, int n4) {
        this.ensureIndex(n2);
        IntArrays.ensureOffsetLength(nArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            int n5 = n2;
            while (n4-- != 0) {
                nArray[n3++] = this.getInt(n5++);
            }
        } else {
            IntListIterator intListIterator = this.listIterator(n2);
            while (n4-- != 0) {
                nArray[n3++] = intListIterator.nextInt();
            }
        }
    }

    @Override
    public void setElements(int n2, int[] nArray, int n3, int n4) {
        this.ensureIndex(n2);
        IntArrays.ensureOffsetLength(nArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.set(i2 + n2, nArray[i2 + n3]);
            }
        } else {
            IntListIterator intListIterator = this.listIterator(n2);
            int n5 = 0;
            while (n5 < n4) {
                intListIterator.nextInt();
                intListIterator.set(nArray[n3 + n5++]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    @Override
    public int hashCode() {
        IntListIterator intListIterator = this.iterator();
        int n2 = 1;
        int n3 = this.size();
        while (n3-- != 0) {
            int n4 = intListIterator.nextInt();
            n2 = 31 * n2 + n4;
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        int n2 = this.size();
        if (n2 != list.size()) {
            return false;
        }
        if (list instanceof IntList) {
            IntListIterator intListIterator = this.listIterator();
            IntListIterator intListIterator2 = ((IntList)list).listIterator();
            while (n2-- != 0) {
                if (intListIterator.nextInt() == intListIterator2.nextInt()) continue;
                return false;
            }
            return true;
        }
        IntListIterator intListIterator = this.listIterator();
        ListIterator listIterator = list.listIterator();
        while (n2-- != 0) {
            if (Objects.equals(intListIterator.next(), listIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Integer> list) {
        if (list == this) {
            return 0;
        }
        if (list instanceof IntList) {
            IntListIterator intListIterator = this.listIterator();
            IntListIterator intListIterator2 = ((IntList)list).listIterator();
            while (intListIterator.hasNext() && intListIterator2.hasNext()) {
                int n2;
                int n3 = intListIterator.nextInt();
                int n4 = Integer.compare(n3, n2 = intListIterator2.nextInt());
                if (n4 == 0) continue;
                return n4;
            }
            return intListIterator2.hasNext() ? -1 : (intListIterator.hasNext() ? 1 : 0);
        }
        IntListIterator intListIterator = this.listIterator();
        ListIterator<? extends Integer> listIterator = list.listIterator();
        while (intListIterator.hasNext() && listIterator.hasNext()) {
            int n5 = ((Comparable)intListIterator.next()).compareTo(listIterator.next());
            if (n5 == 0) continue;
            return n5;
        }
        return listIterator.hasNext() ? -1 : (intListIterator.hasNext() ? 1 : 0);
    }

    @Override
    public boolean rem(int n2) {
        int n3 = this.indexOf(n2);
        if (n3 == -1) {
            return false;
        }
        this.removeInt(n3);
        return true;
    }

    @Override
    public int[] toIntArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return IntArrays.EMPTY_ARRAY;
        }
        int[] nArray = new int[n2];
        this.getElements(0, nArray, 0, n2);
        return nArray;
    }

    @Override
    public int[] toArray(int[] nArray) {
        int n2 = this.size();
        if (nArray.length < n2) {
            nArray = Arrays.copyOf(nArray, n2);
        }
        this.getElements(0, nArray, 0, n2);
        return nArray;
    }

    public boolean addAll(int n2, IntCollection intCollection) {
        this.ensureIndex(n2);
        IntIterator intIterator = intCollection.iterator();
        boolean bl2 = intIterator.hasNext();
        while (intIterator.hasNext()) {
            this.add(n2++, intIterator.nextInt());
        }
        return bl2;
    }

    @Override
    public boolean addAll(IntCollection intCollection) {
        return this.addAll(this.size(), intCollection);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        IntListIterator intListIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("[");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            int n3 = intListIterator.nextInt();
            stringBuilder.append(String.valueOf(n3));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

