/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.type.types.version;

import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.DataPaletteImpl;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.util.CompactArrayUtil;
import com.viaversion.viaversion.util.MathUtil;
import io.netty.buffer.ByteBuf;

public final class PaletteType1_18
extends Type<DataPalette> {
    private final int globalPaletteBits;
    private final PaletteType type;

    public PaletteType1_18(PaletteType paletteType, int n2) {
        super(DataPalette.class);
        this.globalPaletteBits = n2;
        this.type = paletteType;
    }

    @Override
    public DataPalette read(ByteBuf byteBuf) {
        long[] lArray;
        int n2;
        DataPaletteImpl dataPaletteImpl;
        int n3 = byteBuf.readByte();
        int n4 = n3;
        if (n4 == 0) {
            DataPaletteImpl dataPaletteImpl2 = new DataPaletteImpl(this.type.size(), 1);
            dataPaletteImpl2.addId(Type.VAR_INT.readPrimitive(byteBuf));
            Type.LONG_ARRAY_PRIMITIVE.read(byteBuf);
            return dataPaletteImpl2;
        }
        if (n4 < 0 || n4 > this.type.highestBitsPerValue()) {
            n4 = this.globalPaletteBits;
        } else if (this.type == PaletteType.BLOCKS && n4 < 4) {
            n4 = 4;
        }
        if (n4 != this.globalPaletteBits) {
            int n5 = Type.VAR_INT.readPrimitive(byteBuf);
            dataPaletteImpl = new DataPaletteImpl(this.type.size(), n5);
            for (n2 = 0; n2 < n5; ++n2) {
                dataPaletteImpl.addId(Type.VAR_INT.readPrimitive(byteBuf));
            }
        } else {
            dataPaletteImpl = new DataPaletteImpl(this.type.size());
        }
        if ((lArray = (long[])Type.LONG_ARRAY_PRIMITIVE.read(byteBuf)).length > 0) {
            n2 = (char)(64 / n4);
            int n6 = (this.type.size() + n2 - 1) / n2;
            if (lArray.length == n6) {
                CompactArrayUtil.iterateCompactArrayWithPadding(n4, this.type.size(), lArray, n4 == this.globalPaletteBits ? dataPaletteImpl::setIdAt : dataPaletteImpl::setPaletteIndexAt);
            }
        }
        return dataPaletteImpl;
    }

    @Override
    public void write(ByteBuf byteBuf, DataPalette dataPalette) {
        int n2 = dataPalette.size();
        if (n2 == 1) {
            byteBuf.writeByte(0);
            Type.VAR_INT.writePrimitive(byteBuf, dataPalette.idByIndex(0));
            Type.VAR_INT.writePrimitive(byteBuf, 0);
            return;
        }
        int n3 = this.type == PaletteType.BLOCKS ? 4 : 1;
        int n4 = Math.max(n3, MathUtil.ceilLog2(n2));
        if (n4 > this.type.highestBitsPerValue()) {
            n4 = this.globalPaletteBits;
        }
        byteBuf.writeByte(n4);
        if (n4 != this.globalPaletteBits) {
            Type.VAR_INT.writePrimitive(byteBuf, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                Type.VAR_INT.writePrimitive(byteBuf, dataPalette.idByIndex(i2));
            }
        }
        Type.LONG_ARRAY_PRIMITIVE.write(byteBuf, CompactArrayUtil.createCompactArrayWithPadding(n4, this.type.size(), n4 == this.globalPaletteBits ? dataPalette::idAt : dataPalette::paletteIndexAt));
    }
}

