/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.type.types.version;

import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSectionImpl;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.util.CompactArrayUtil;
import io.netty.buffer.ByteBuf;

public class ChunkSectionType1_13
extends Type<ChunkSection> {
    public ChunkSectionType1_13() {
        super("Chunk Section Type", ChunkSection.class);
    }

    @Override
    public ChunkSection read(ByteBuf byteBuf) {
        int n2;
        long[] lArray;
        ChunkSectionImpl chunkSectionImpl;
        int n3 = byteBuf.readUnsignedByte();
        if (n3 > 8) {
            n3 = 14;
        } else if (n3 < 4) {
            n3 = 4;
        }
        if (n3 != 14) {
            int n4 = Type.VAR_INT.readPrimitive(byteBuf);
            chunkSectionImpl = new ChunkSectionImpl(true, n4);
            DataPalette dataPalette = chunkSectionImpl.palette(PaletteType.BLOCKS);
            for (int i2 = 0; i2 < n4; ++i2) {
                dataPalette.addId(Type.VAR_INT.readPrimitive(byteBuf));
            }
        } else {
            chunkSectionImpl = new ChunkSectionImpl(true);
        }
        if ((lArray = (long[])Type.LONG_ARRAY_PRIMITIVE.read(byteBuf)).length > 0 && lArray.length == (n2 = (int)Math.ceil((double)(4096 * n3) / 64.0))) {
            DataPalette dataPalette = chunkSectionImpl.palette(PaletteType.BLOCKS);
            CompactArrayUtil.iterateCompactArray(n3, 4096, lArray, n3 == 14 ? dataPalette::setIdAt : dataPalette::setPaletteIndexAt);
        }
        return chunkSectionImpl;
    }

    @Override
    public void write(ByteBuf byteBuf, ChunkSection chunkSection) {
        int n2 = 4;
        DataPalette dataPalette = chunkSection.palette(PaletteType.BLOCKS);
        while (dataPalette.size() > 1 << n2) {
            ++n2;
        }
        if (n2 > 8) {
            n2 = 14;
        }
        byteBuf.writeByte(n2);
        if (n2 != 14) {
            Type.VAR_INT.writePrimitive(byteBuf, dataPalette.size());
            for (int i2 = 0; i2 < dataPalette.size(); ++i2) {
                Type.VAR_INT.writePrimitive(byteBuf, dataPalette.idByIndex(i2));
            }
        }
        long[] lArray = CompactArrayUtil.createCompactArray(n2, 4096, n2 == 14 ? dataPalette::idAt : dataPalette::paletteIndexAt);
        Type.LONG_ARRAY_PRIMITIVE.write(byteBuf, lArray);
    }
}

