/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.type.types.minecraft;

import com.viaversion.viaversion.api.minecraft.item.DataItem;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.type.types.minecraft.BaseItemType;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FlatVarIntItemType
extends BaseItemType {
    public FlatVarIntItemType() {
        super("FlatVarIntItem");
    }

    @Override
    public @Nullable Item read(ByteBuf byteBuf) {
        boolean bl2 = byteBuf.readBoolean();
        if (!bl2) {
            return null;
        }
        DataItem dataItem = new DataItem();
        dataItem.setIdentifier(VAR_INT.readPrimitive(byteBuf));
        dataItem.setAmount(byteBuf.readByte());
        dataItem.setTag((CompoundTag)NBT.read(byteBuf));
        return dataItem;
    }

    @Override
    public void write(ByteBuf byteBuf, @Nullable Item item) {
        if (item == null) {
            byteBuf.writeBoolean(false);
        } else {
            byteBuf.writeBoolean(true);
            VAR_INT.writePrimitive(byteBuf, item.identifier());
            byteBuf.writeByte(item.amount());
            NBT.write(byteBuf, item.tag());
        }
    }
}

