/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.type.types;

import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.TypeConverter;
import io.netty.buffer.ByteBuf;

public class VarLongType
extends Type<Long>
implements TypeConverter<Long> {
    public VarLongType() {
        super("VarLong", Long.class);
    }

    public long readPrimitive(ByteBuf byteBuf) {
        byte by2;
        long l2 = 0L;
        int n2 = 0;
        do {
            by2 = byteBuf.readByte();
            l2 |= (long)(by2 & 0x7F) << n2++ * 7;
            if (n2 <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((by2 & 0x80) == 128);
        return l2;
    }

    public void writePrimitive(ByteBuf byteBuf, long l2) {
        do {
            int n2 = (int)(l2 & 0x7FL);
            if ((l2 >>>= 7) != 0L) {
                n2 |= 0x80;
            }
            byteBuf.writeByte(n2);
        } while (l2 != 0L);
    }

    @Override
    @Deprecated
    public Long read(ByteBuf byteBuf) {
        return this.readPrimitive(byteBuf);
    }

    @Override
    @Deprecated
    public void write(ByteBuf byteBuf, Long l2) {
        this.writePrimitive(byteBuf, l2);
    }

    @Override
    public Long from(Object object) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        return (Long)object;
    }
}

