/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.type.types;

import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.TypeConverter;
import io.netty.buffer.ByteBuf;

public class VarIntType
extends Type<Integer>
implements TypeConverter<Integer> {
    public VarIntType() {
        super("VarInt", Integer.class);
    }

    public int readPrimitive(ByteBuf byteBuf) {
        byte by2;
        int n2 = 0;
        int n3 = 0;
        do {
            by2 = byteBuf.readByte();
            n2 |= (by2 & 0x7F) << n3++ * 7;
            if (n3 <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((by2 & 0x80) == 128);
        return n2;
    }

    public void writePrimitive(ByteBuf byteBuf, int n2) {
        while ((n2 & 0xFFFFFF80) != 0) {
            byteBuf.writeByte(n2 & 0x7F | 0x80);
            n2 >>>= 7;
        }
        byteBuf.writeByte(n2);
    }

    @Override
    @Deprecated
    public Integer read(ByteBuf byteBuf) {
        return this.readPrimitive(byteBuf);
    }

    @Override
    @Deprecated
    public void write(ByteBuf byteBuf, Integer n2) {
        this.writePrimitive(byteBuf, n2);
    }

    @Override
    public Integer from(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        return (Integer)object;
    }
}

