/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.type.types;

import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;

public class ArrayType<T>
extends Type<T[]> {
    private final Type<T> elementType;

    public ArrayType(Type<T> type) {
        super(type.getTypeName() + " Array", ArrayType.getArrayClass(type.getOutputClass()));
        this.elementType = type;
    }

    public static Class<?> getArrayClass(Class<?> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    @Override
    public T[] read(ByteBuf byteBuf) {
        int n2 = Type.VAR_INT.readPrimitive(byteBuf);
        Object[] objectArray = (Object[])Array.newInstance(this.elementType.getOutputClass(), n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.elementType.read(byteBuf);
        }
        return objectArray;
    }

    @Override
    public void write(ByteBuf byteBuf, T[] TArray) {
        Type.VAR_INT.writePrimitive(byteBuf, TArray.length);
        for (T t2 : TArray) {
            this.elementType.write(byteBuf, t2);
        }
    }
}

