/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.protocol.version;

import com.google.common.base.X;
import com.viaversion.viaversion.api.protocol.version.VersionRange;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ProtocolVersion {
    private static final Int2ObjectMap<ProtocolVersion> VERSIONS = new Int2ObjectOpenHashMap<ProtocolVersion>();
    private static final List<ProtocolVersion> VERSION_LIST = new ArrayList<ProtocolVersion>();
    public static final ProtocolVersion v1_4_6 = ProtocolVersion.register(51, "1.4.6/7", new VersionRange("1.4", 6, 7));
    public static final ProtocolVersion v1_5_1 = ProtocolVersion.register(60, "1.5/1.5.1", new VersionRange("1.5", 0, 1));
    public static final ProtocolVersion v1_5_2 = ProtocolVersion.register(61, "1.5.2");
    public static final ProtocolVersion v_1_6_1 = ProtocolVersion.register(73, "1.6.1");
    public static final ProtocolVersion v_1_6_2 = ProtocolVersion.register(74, "1.6.2");
    public static final ProtocolVersion v_1_6_3 = ProtocolVersion.register(77, "1.6.3");
    public static final ProtocolVersion v_1_6_4 = ProtocolVersion.register(78, "1.6.4");
    public static final ProtocolVersion v1_7_1 = ProtocolVersion.register(4, "1.7.2-1.7.5", new VersionRange("1.7", 2, 5));
    public static final ProtocolVersion v1_7_6 = ProtocolVersion.register(5, "1.7.6-1.7.10", new VersionRange("1.7", 6, 10));
    public static final ProtocolVersion v1_8 = ProtocolVersion.register(47, "1.8.x");
    public static final ProtocolVersion v1_9 = ProtocolVersion.register(107, "1.9");
    public static final ProtocolVersion v1_9_1 = ProtocolVersion.register(108, "1.9.1");
    public static final ProtocolVersion v1_9_2 = ProtocolVersion.register(109, "1.9.2");
    public static final ProtocolVersion v1_9_3 = ProtocolVersion.register(110, "1.9.3/4", new VersionRange("1.9", 3, 4));
    public static final ProtocolVersion v1_10 = ProtocolVersion.register(210, "1.10.x");
    public static final ProtocolVersion v1_11 = ProtocolVersion.register(315, "1.11");
    public static final ProtocolVersion v1_11_1 = ProtocolVersion.register(316, "1.11.1/2", new VersionRange("1.11", 1, 2));
    public static final ProtocolVersion v1_12 = ProtocolVersion.register(335, "1.12");
    public static final ProtocolVersion v1_12_1 = ProtocolVersion.register(338, "1.12.1");
    public static final ProtocolVersion v1_12_2 = ProtocolVersion.register(340, "1.12.2");
    public static final ProtocolVersion v1_13 = ProtocolVersion.register(393, "1.13");
    public static final ProtocolVersion v1_13_1 = ProtocolVersion.register(401, "1.13.1");
    public static final ProtocolVersion v1_13_2 = ProtocolVersion.register(404, "1.13.2");
    public static final ProtocolVersion v1_14 = ProtocolVersion.register(477, "1.14");
    public static final ProtocolVersion v1_14_1 = ProtocolVersion.register(480, "1.14.1");
    public static final ProtocolVersion v1_14_2 = ProtocolVersion.register(485, "1.14.2");
    public static final ProtocolVersion v1_14_3 = ProtocolVersion.register(490, "1.14.3");
    public static final ProtocolVersion v1_14_4 = ProtocolVersion.register(498, "1.14.4");
    public static final ProtocolVersion v1_15 = ProtocolVersion.register(573, "1.15");
    public static final ProtocolVersion v1_15_1 = ProtocolVersion.register(575, "1.15.1");
    public static final ProtocolVersion v1_15_2 = ProtocolVersion.register(578, "1.15.2");
    public static final ProtocolVersion v1_16 = ProtocolVersion.register(735, "1.16");
    public static final ProtocolVersion v1_16_1 = ProtocolVersion.register(736, "1.16.1");
    public static final ProtocolVersion v1_16_2 = ProtocolVersion.register(751, "1.16.2");
    public static final ProtocolVersion v1_16_3 = ProtocolVersion.register(753, "1.16.3");
    public static final ProtocolVersion v1_16_4 = ProtocolVersion.register(754, "1.16.4/5", new VersionRange("1.16", 4, 5));
    public static final ProtocolVersion v1_17 = ProtocolVersion.register(755, "1.17");
    public static final ProtocolVersion v1_17_1 = ProtocolVersion.register(756, "1.17.1");
    public static final ProtocolVersion v1_18 = ProtocolVersion.register(757, "1.18/1.18.1", new VersionRange("1.18", 0, 1));
    public static final ProtocolVersion v1_18_2 = ProtocolVersion.register(758, "1.18.2");
    public static final ProtocolVersion v1_19 = ProtocolVersion.register(759, "1.19");
    public static final ProtocolVersion v1_19_1 = ProtocolVersion.register(760, "1.19.1/2", new VersionRange("1.19", 1, 2));
    public static final ProtocolVersion v1_19_3 = ProtocolVersion.register(761, "1.19.3");
    public static final ProtocolVersion v1_19_4 = ProtocolVersion.register(762, "1.19.4");
    public static final ProtocolVersion v1_20 = ProtocolVersion.register(763, "1.20/1.20.1", new VersionRange("1.20", 0, 1));
    public static final ProtocolVersion unknown = ProtocolVersion.register(-1, "UNKNOWN");
    private final int version;
    private final int snapshotVersion;
    private final String name;
    private final boolean versionWildcard;
    private final Set<String> includedVersions;

    public static ProtocolVersion register(int n2, String string) {
        return ProtocolVersion.register(n2, -1, string);
    }

    public static ProtocolVersion register(int n2, int n3, String string) {
        return ProtocolVersion.register(n2, n3, string, null);
    }

    public static ProtocolVersion register(int n2, String string, @Nullable VersionRange versionRange) {
        return ProtocolVersion.register(n2, -1, string, versionRange);
    }

    public static ProtocolVersion register(int n2, int n3, String string, @Nullable VersionRange versionRange) {
        ProtocolVersion protocolVersion = new ProtocolVersion(n2, n3, string, versionRange);
        VERSION_LIST.add(protocolVersion);
        VERSIONS.put(protocolVersion.getVersion(), protocolVersion);
        if (protocolVersion.isSnapshot()) {
            VERSIONS.put(protocolVersion.getFullSnapshotVersion(), protocolVersion);
        }
        return protocolVersion;
    }

    public static boolean isRegistered(int n2) {
        return VERSIONS.containsKey(n2);
    }

    public static @NonNull ProtocolVersion getProtocol(int n2) {
        ProtocolVersion protocolVersion = (ProtocolVersion)VERSIONS.get(n2);
        if (protocolVersion != null) {
            return protocolVersion;
        }
        return new ProtocolVersion(n2, "Unknown (" + n2 + ")");
    }

    public static int getIndex(ProtocolVersion protocolVersion) {
        return VERSION_LIST.indexOf(protocolVersion);
    }

    public static List<ProtocolVersion> getProtocols() {
        return Collections.unmodifiableList(VERSION_LIST);
    }

    public static @Nullable ProtocolVersion getClosest(String string) {
        for (ProtocolVersion protocolVersion : VERSIONS.values()) {
            String string2;
            String string3 = protocolVersion.getName();
            if (string3.equals(string)) {
                return protocolVersion;
            }
            if (!(protocolVersion.isVersionWildcard() ? (string2 = string3.substring(0, string3.length() - 2)).equals(string) || string.startsWith(string3.substring(0, string3.length() - 1)) : protocolVersion.isRange() && protocolVersion.getIncludedVersions().contains(string))) continue;
            return protocolVersion;
        }
        return null;
    }

    public ProtocolVersion(int n2, String string) {
        this(n2, -1, string, null);
    }

    public ProtocolVersion(int n2, int n3, String string, @Nullable VersionRange versionRange) {
        this.version = n2;
        this.snapshotVersion = n3;
        this.name = string;
        this.versionWildcard = string.endsWith(".x");
        X.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_(!this.versionWildcard || versionRange == null, "A version cannot be a wildcard and a range at the same time!");
        if (versionRange != null) {
            this.includedVersions = new LinkedHashSet<String>();
            for (int i2 = versionRange.rangeFrom(); i2 <= versionRange.rangeTo(); ++i2) {
                if (i2 == 0) {
                    this.includedVersions.add(versionRange.baseVersion());
                }
                this.includedVersions.add(versionRange.baseVersion() + "." + i2);
            }
        } else {
            this.includedVersions = Collections.singleton(string);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getSnapshotVersion() {
        X.checkArgument(this.isSnapshot());
        return this.snapshotVersion;
    }

    public int getFullSnapshotVersion() {
        X.checkArgument(this.isSnapshot());
        return 0x40000000 | this.snapshotVersion;
    }

    public int getOriginalVersion() {
        return this.snapshotVersion == -1 ? this.version : 0x40000000 | this.snapshotVersion;
    }

    public boolean isKnown() {
        return this.version != -1;
    }

    public boolean isRange() {
        return this.includedVersions.size() != 1;
    }

    public Set<String> getIncludedVersions() {
        return Collections.unmodifiableSet(this.includedVersions);
    }

    public boolean isVersionWildcard() {
        return this.versionWildcard;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSnapshot() {
        return this.snapshotVersion != -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProtocolVersion protocolVersion = (ProtocolVersion)object;
        return this.version == protocolVersion.version;
    }

    public int hashCode() {
        return this.version;
    }

    public String toString() {
        return String.format("%s (%d)", this.name, this.version);
    }
}

