/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.protocol.remapper;

import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.TypeRemapper;
import com.viaversion.viaversion.api.protocol.remapper.ValueReader;
import com.viaversion.viaversion.api.protocol.remapper.ValueTransformer;
import com.viaversion.viaversion.api.protocol.remapper.ValueWriter;
import com.viaversion.viaversion.api.type.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class PacketHandlers
implements PacketHandler {
    private final List<PacketHandler> packetHandlers = new ArrayList<PacketHandler>();

    protected PacketHandlers() {
        this.register();
    }

    public <T> void map(Type<T> type) {
        this.handler(packetWrapper -> packetWrapper.write(type, packetWrapper.read(type)));
    }

    public void map(Type type, Type type2) {
        this.handler(packetWrapper -> packetWrapper.write(type2, packetWrapper.read(type)));
    }

    public <T1, T2> void map(ValueTransformer<T1, T2> valueTransformer) {
        if (valueTransformer.getInputType() == null) {
            throw new IllegalArgumentException("Use map(Type<T1>, ValueTransformer<T1, T2>) for value transformers without specified input type!");
        }
        this.map(valueTransformer.getInputType(), valueTransformer);
    }

    public <T1, T2> void map(Type<T1> type, ValueTransformer<T1, T2> valueTransformer) {
        this.map(new TypeRemapper<T1>(type), valueTransformer);
    }

    public <T> void map(ValueReader<T> valueReader, ValueWriter<T> valueWriter) {
        this.handler(packetWrapper -> valueWriter.write(packetWrapper, valueReader.read(packetWrapper)));
    }

    public void handler(PacketHandler packetHandler) {
        this.packetHandlers.add(packetHandler);
    }

    public <T> void create(Type<T> type, T t2) {
        this.handler(packetWrapper -> packetWrapper.write(type, t2));
    }

    public void read(Type<?> type) {
        this.handler(packetWrapper -> packetWrapper.read(type));
    }

    protected abstract void register();

    @Override
    public final void handle(PacketWrapper packetWrapper) {
        for (PacketHandler packetHandler : this.packetHandlers) {
            packetHandler.handle(packetWrapper);
        }
    }
}

